/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ProgWidgetRenderer {
    public static void renderProgWidget2d(IProgWidget progWidget) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(progWidget.getTexture());
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        wr.func_225582_a_(0.0, (double)height, 0.0).func_225583_a_(0.0f, v).func_181675_d();
        wr.func_225582_a_((double)width, (double)height, 0.0).func_225583_a_(u, v).func_181675_d();
        wr.func_225582_a_((double)width, 0.0, 0.0).func_225583_a_(u, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderProgWidget3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, IProgWidget progWidget) {
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(progWidget.getTexture()), (posMat, builder) -> {
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)width, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)width, (float)height, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, 0.0f, (float)height, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, v).func_227886_a_(0xF000F0).func_181675_d();
        });
    }

    public static void renderExtras(IProgWidget progWidget) {
        if (progWidget.getExtraStringInfo() != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)0.5, (double)0.5, (double)0.5);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            List<String> splittedInfo = PneumaticCraftUtils.splitString(progWidget.getExtraStringInfo(), 20);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringLength = fr.func_78256_a(splittedInfo.get(i));
                int startX = progWidget.getWidth() / 2 - stringLength / 4;
                int n = progWidget.getHeight() / 2;
                fr.getClass();
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                fr.getClass();
                int n3 = n2 + (9 + 1) * i / 2;
                fr.getClass();
                int startY = n3 - 9 / 4;
                fr.getClass();
                AbstractGui.fill((int)(startX * 2 - 1), (int)(startY * 2 - 1), (int)(startX * 2 + stringLength + 1), (int)(startY * 2 + 9 + 1), (int)-1);
                fr.func_211126_b(splittedInfo.get(i), (float)(startX * 2), (float)(startY * 2), -16777216);
            }
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderCraftingExtras(ProgWidgetCrafting progWidget) {
        ItemStack recipe = progWidget.getRecipeResult(ClientUtils.getClientWorld());
        if (recipe != null) {
            GuiUtils.drawItemStack(recipe, 8, progWidget.getHeight() / 2 - 8, recipe.func_190916_E() + "");
        }
    }

    public static void renderItemFilterExtras(ProgWidgetItemFilter progWidget) {
        if (progWidget.getVariable().isEmpty()) {
            if (!progWidget.getFilter().func_190926_b()) {
                GuiUtils.drawItemStack(progWidget.getFilter(), 10, 2, "");
            }
        } else {
            ProgWidgetRenderer.renderExtras(progWidget);
        }
    }
}

