/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RenderSearchItemBlock {
    private final BlockPos pos;
    private final World world;
    private long lastCheck = 0L;
    private int cachedAmount;

    public RenderSearchItemBlock(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public int getSearchedItemCount() {
        if (this.world.func_82737_E() - this.lastCheck >= 20L) {
            this.cachedAmount = 0;
            IOHelper.getInventoryForTE(this.world.func_175625_s(this.pos)).ifPresent(handler -> {
                int itemCount = 0;
                Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
                if (searchedItem != null) {
                    for (int l = 0; l < handler.getSlots(); ++l) {
                        if (handler.getStackInSlot(l).func_190926_b()) continue;
                        itemCount += RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchedItem);
                    }
                }
                this.cachedAmount = itemCount;
            });
            this.lastCheck = this.world.func_82737_E();
        }
        return this.cachedAmount;
    }

    public static int getSearchedItemCount(ItemStack stack, Item item) {
        int itemCount = 0;
        if (stack.func_77973_b() == item) {
            itemCount += stack.func_190916_E();
        }
        List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, item);
        }
        return itemCount;
    }

    public void renderSearchBlock(MatrixStack matrixStack, IVertexBuilder builder, int totalCount, float partialTicks) {
        RenderSearchItemBlock.renderSearch(matrixStack, builder, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, this.getSearchedItemCount(), totalCount, partialTicks);
    }

    public static void renderSearch(MatrixStack matrixStack, IVertexBuilder builder, double x, double y, double z, int itemCount, int totalCount, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, y, z);
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float ratio = (float)itemCount / (float)totalCount;
        float diff = (1.0f - ratio) / 1.5f;
        float size = 1.0f - diff;
        float f = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() & 0x1FL) + partialTicks) / 5.092f;
        float alpha = 0.65f + MathHelper.func_76126_a((float)f) * 0.15f;
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, -size, size, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(posMat, size, size, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(posMat, size, -size, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(posMat, -size, -size, 0.0f).func_227885_a_(0.0f, 1.0f, 0.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        matrixStack.func_227865_b_();
    }
}

