/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class WidgetList<T>
extends Widget
implements ITooltipProvider {
    private final Consumer<WidgetList<T>> pressable;
    private final List<T> items = new ArrayList<T>();
    private int selected = -1;
    private long lastClick = 0L;
    private boolean doubleClicked;
    private int fgColor = 0x404040;
    private int selectedFg = 0xFFFFFF;
    private int selectedBg = 0;
    private boolean inverseSelected = true;
    private ToolTipType toolTipType = ToolTipType.AUTO;

    public WidgetList(int xIn, int yIn, int width, int height) {
        this(xIn, yIn, width, height, null);
    }

    public WidgetList(int xIn, int yIn, int width, int height, Consumer<WidgetList<T>> pressable) {
        super(xIn, yIn, width, height, "");
        this.pressable = pressable;
    }

    public WidgetList setColor(int color) {
        this.fgColor = color;
        return this;
    }

    public WidgetList setToolTipType(ToolTipType toolTipType) {
        this.toolTipType = toolTipType;
        return this;
    }

    public WidgetList setSelectedColors(int selectedFg, int selectedBg) {
        this.selectedFg = selectedFg;
        this.selectedBg = selectedBg;
        return this;
    }

    public WidgetList inverseSelected(boolean inverse) {
        this.inverseSelected = inverse;
        return this;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.drawList();
        }
    }

    public boolean isDoubleClicked() {
        return this.doubleClicked;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public void unselectAll() {
        this.selected = -1;
    }

    public List<T> getLines() {
        return ImmutableList.copyOf(this.items);
    }

    public T getSelectedLine() {
        return this.selected >= 0 && this.selected < this.items.size() ? (T)this.items.get(this.selected) : null;
    }

    public boolean contains(T s) {
        return this.items.contains(s);
    }

    public void add(T s) {
        this.items.add(s);
    }

    public void removeSelected() {
        if (this.selected >= 0 && this.selected < this.items.size()) {
            this.items.remove(this.selected);
            this.updateSelection();
        }
    }

    public void clear() {
        this.items.clear();
        this.setSelected(-1);
    }

    private void updateSelection() {
        if (this.items.isEmpty()) {
            this.selected = -1;
        } else if (this.selected >= this.items.size()) {
            this.selected = this.items.size() - 1;
        }
    }

    public int size() {
        return this.items.size();
    }

    private void drawList() {
        Minecraft mc = Minecraft.func_71410_x();
        int sf = mc.field_71474_y.field_74335_Z;
        mc.field_71466_p.getClass();
        int h = 9;
        int lines = this.height / h;
        RenderSystem.pushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.x * sf), (int)((this.y + this.height) * sf), (int)(this.width * sf), (int)(this.height * sf));
        if (this.inverseSelected && this.selected >= 0) {
            RenderSystem.disableTexture();
            WidgetList.fill((int)this.x, (int)(this.y + h * this.selected), (int)(this.x + this.width), (int)(this.y + h * (this.selected + 1)), (int)(0xFF000000 | this.selectedBg));
            RenderSystem.enableTexture();
        }
        RenderSystem.translated((double)this.x, (double)this.y, (double)0.0);
        RenderSystem.scaled((double)0.75, (double)1.0, (double)1.0);
        for (int i = 0; i < this.items.size() && i < lines; ++i) {
            mc.field_71466_p.func_211126_b(this.items.get(i).toString(), 0.0f, (float)(i * h), i == this.selected ? this.selectedFg : this.fgColor);
        }
        GL11.glDisable((int)3089);
        RenderSystem.popMatrix();
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.active) {
            long now = System.currentTimeMillis();
            Minecraft.func_71410_x().field_71466_p.getClass();
            int h = 9;
            int newSel = MathHelper.func_76125_a((int)((int)(mouseY - (double)this.y) / h), (int)0, (int)(this.items.size() - 1));
            this.doubleClicked = now - this.lastClick < 250L && newSel == this.selected;
            this.setSelected(newSel);
            this.lastClick = now;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
        }
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        if (this.toolTipType == ToolTipType.NONE) {
            return;
        }
        Minecraft.func_71410_x().field_71466_p.getClass();
        int h = 9;
        int idx = Math.max(0, (int)(mouseY - (double)this.y) / h);
        if (idx >= 0 && idx < this.items.size()) {
            String s = this.items.get(idx).toString();
            if (this.toolTipType == ToolTipType.ALWAYS || Minecraft.func_71410_x().field_71466_p.func_78256_a(s) * 3 / 4 > this.width) {
                curTip.add(s);
            }
        }
    }

    public static enum ToolTipType {
        NONE,
        AUTO,
        ALWAYS;

    }
}

