/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.client.gui.IExtraGuiHandling;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegulatorTube;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.event.DateEventHandler;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final double MINIGUN_RADIUS = 1.1;
    private static final double MINIGUN_TEXT_SIZE = 0.55;
    private static final float MAX_SCREEN_ROLL = 25.0f;
    private static float currentScreenRoll = 0.0f;
    private static final ProgressingLine minigunFire = new ProgressingLine().setProgress(1.0f);
    private static int lastWidth = -1;
    private static int lastHeight = -1;
    private static final int Z_LEVEL = 233;

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Pre event) {
        ClientEventHandler.setRenderHead(event.getEntity(), false);
    }

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Post event) {
        ClientEventHandler.setRenderHead(event.getEntity(), true);
    }

    private static void setRenderHead(LivingEntity entity, boolean setRender) {
        EntityRenderer renderer;
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModItems.PNEUMATIC_HELMET.get() && (PNCConfig.Client.Armor.fancyArmorModels || DateEventHandler.isIronManEvent()) && (renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entity)) instanceof BipedRenderer) {
            BipedModel modelBiped = (BipedModel)((BipedRenderer)renderer).func_217764_d();
            modelBiped.field_78116_c.field_78806_j = setRender;
        }
    }

    @SubscribeEvent
    public static void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().func_195544_aj() && ClientUtils.getClientPlayer() != null && (ModuleRegulatorTube.inverted || !ModuleRegulatorTube.inLine)) {
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow mw = mc.func_228018_at_();
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String warning = TextFormatting.RED + I18n.func_135052_a((String)("gui.regulatorTube.hudMessage." + (ModuleRegulatorTube.inverted ? "inverted" : "notInLine")), (Object[])new Object[0]);
            fontRenderer.func_175063_a(warning, (float)mw.func_198107_o() / 2.0f - (float)fontRenderer.func_78256_a(warning) / 2.0f, (float)mw.func_198087_p() / 2.0f + 30.0f, -1);
        }
    }

    @SubscribeEvent
    public static void renderFirstPersonMinigunTraces(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemMinigun) {
                ItemStack ammo;
                Minigun minigun = ((ItemMinigun)stack.func_77973_b()).getMinigun(stack, (PlayerEntity)player);
                int w = event.getWindow().func_198107_o();
                int h = event.getWindow().func_198087_p();
                if (minigun.isMinigunActivated() && minigun.getMinigunSpeed() == 0.4f) {
                    ClientEventHandler.drawBulletTraces2D(minigun.getAmmoColor() | 0x40000000, w, h);
                }
                if (!(ammo = minigun.getAmmoStack()).func_190926_b()) {
                    GuiUtils.drawItemStack(ammo, w / 2 + 16, h / 2 - 7);
                    int remaining = ammo.func_77958_k() - ammo.func_77952_i();
                    RenderSystem.pushMatrix();
                    RenderSystem.translated((double)((float)w / 2.0f + 32.0f), (double)((float)h / 2.0f - 1.0f), (double)0.0);
                    RenderSystem.scaled((double)0.55, (double)0.55, (double)1.0);
                    String text = remaining + "/" + ammo.func_77958_k();
                    mc.field_71466_p.func_211126_b(text, 1.0f, 0.0f, 0);
                    mc.field_71466_p.func_211126_b(text, -1.0f, 0.0f, 0);
                    mc.field_71466_p.func_211126_b(text, 0.0f, 1.0f, 0);
                    mc.field_71466_p.func_211126_b(text, 0.0f, -1.0f, 0);
                    mc.field_71466_p.func_211126_b(text, 0.0f, 0.0f, minigun.getAmmoColor());
                    RenderSystem.popMatrix();
                }
                mc.func_110434_K().func_110577_a(Textures.MINIGUN_CROSSHAIR);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.color4f((float)0.2f, (float)1.0f, (float)0.2f, (float)0.6f);
                AbstractGui.blit((int)(w / 2 - 7), (int)(h / 2 - 7), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                event.setCanceled(true);
            }
        }
    }

    private static void drawBulletTraces2D(int color, int w, int h) {
        RenderSystem.pushMatrix();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GL11.glEnable((int)2852);
        int x = w / 2;
        int y = h / 2;
        int[] cols = RenderUtils.decomposeColor(color);
        Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        float f = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? 0.665f : 0.335f;
        float endX = (float)w * f;
        float endY = (float)h * 0.685f;
        for (int i = 0; i < 5; ++i) {
            int stipple = 0xFFFF & ~(3 << rand.nextInt(16));
            GL11.glLineStipple((int)4, (short)((short)stipple));
            bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            bb.func_225582_a_((double)(x + rand.nextInt(12) - 6), (double)(y + rand.nextInt(12) - 6), 0.0).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            bb.func_225582_a_((double)endX, (double)endY, 0.0).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GL11.glDisable((int)2852);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    @SubscribeEvent
    public static void renderThirdPersonMinigunTraces(RenderWorldLastEvent event) {
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer((RenderType)RenderType.field_228614_Q_);
        matrixStack.func_227860_a_();
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        for (PlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            Minigun minigun;
            ItemStack curItem;
            if (thisPlayer == player && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || (curItem = player.func_184614_ca()).func_77973_b() != ModItems.MINIGUN.get() || !(minigun = ((ItemMinigun)ModItems.MINIGUN.get()).getMinigun(curItem, player)).isMinigunActivated() || minigun.getMinigunSpeed() != 0.4f) continue;
            matrixStack.func_227860_a_();
            Vec3d startVec = player.func_213303_ch().func_72441_c(0.0, (double)(player.func_70047_e() / 2.0f), 0.0).func_178787_e(player.func_70040_Z());
            Vec3d endVec = startVec.func_178787_e(player.func_70040_Z().func_186678_a(20.0));
            ClientEventHandler.minigunFire.startX = startVec.field_72450_a;
            ClientEventHandler.minigunFire.startY = startVec.field_72448_b;
            ClientEventHandler.minigunFire.startZ = startVec.field_72449_c;
            for (int i = 0; i < 5; ++i) {
                ClientEventHandler.minigunFire.endX = endVec.field_72450_a + player.func_70681_au().nextDouble() - 0.5;
                ClientEventHandler.minigunFire.endY = endVec.field_72448_b + player.func_70681_au().nextDouble() - 0.5;
                ClientEventHandler.minigunFire.endZ = endVec.field_72449_c + player.func_70681_au().nextDouble() - 0.5;
                RenderUtils.renderProgressingLine(minigunFire, matrixStack, builder, 0xFF000000 | minigun.getAmmoColor());
            }
            buffer.func_228462_a_((RenderType)RenderType.field_228614_Q_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    @SubscribeEvent
    public static void screenTilt(EntityViewRenderEvent.CameraSetup event) {
        if (event.getInfo().func_216773_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getInfo().func_216773_g();
            if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.FEET) && !player.field_70122_E) {
                float targetRoll;
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                float div = 50.0f;
                if (handler.isJetBootsActive() && !handler.isJetBootsBuilderMode()) {
                    float roll = player.field_70759_as - player.field_70758_at;
                    if ((double)Math.abs(roll) < 1.0E-4) {
                        targetRoll = 0.0f;
                    } else {
                        targetRoll = Math.signum(roll) * 25.0f;
                        div = Math.abs(400.0f / roll);
                    }
                } else {
                    targetRoll = 0.0f;
                }
                currentScreenRoll += (targetRoll - currentScreenRoll) / div;
                event.setRoll(currentScreenRoll);
            } else {
                currentScreenRoll = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void jetBootsEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntity player = event.player;
            if (player == null || player.field_70170_p == null) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (!(!handler.isJetBootsActive() || handler.isJetBootsEnabled() && settings.field_74314_A.func_151470_d())) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(false));
                handler.setJetBootsActive(false);
            } else if (!handler.isJetBootsActive() && handler.isJetBootsEnabled() && settings.field_74314_A.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketJetBootsActivate(true));
                handler.setJetBootsActive(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerPreRotateEvent(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(player);
        JetBootsStateTracker.JetBootsState state = tracker.getJetBootsState(player);
        if (state != null && state.shouldRotatePlayer()) {
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(ClientEventHandler.makeQuaternion(player));
            player.field_184618_aE = 0.0f;
            player.field_70721_aZ = 0.0f;
        }
    }

    @SubscribeEvent
    public static void playerPostRotateEvent(RenderPlayerEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(player);
        JetBootsStateTracker.JetBootsState state = tracker.getJetBootsState(player);
        if (state != null && state.shouldRotatePlayer()) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    private static Quaternion makeQuaternion(PlayerEntity player) {
        Vec3d forward = player.func_70040_Z();
        double dot = new Vec3d(0.0, 1.0, 0.0).func_72430_b(forward);
        if (Math.abs(dot + 1.0) < 1.0E-6) {
            return new Quaternion(0.0f, 1.0f, 0.0f, (float)Math.PI);
        }
        if (Math.abs(dot - 1.0) < 1.0E-6) {
            return new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        }
        Vec3d rotAxis = new Vec3d(0.0, 1.0, 0.0).func_72431_c(forward).func_72432_b();
        double a2 = Math.acos(dot) * 0.5;
        float s = (float)Math.sin(a2);
        return new Quaternion((float)rotAxis.field_72450_a * s, (float)rotAxis.field_72448_b * s, (float)rotAxis.field_72449_c * s, (float)Math.cos(a2));
    }

    @SubscribeEvent
    public static void adjustFOVEvent(FOVUpdateEvent event) {
        float modifier = 1.0f;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = event.getEntity().func_184582_a(slot);
            if (!(stack.func_77973_b() instanceof IFOVModifierItem)) continue;
            modifier *= ((IFOVModifierItem)stack.func_77973_b()).getFOVModifier(stack, event.getEntity(), slot);
        }
        event.setNewfov(event.getNewfov() * modifier);
    }

    @SubscribeEvent
    public static void fogDensityEvent(EntityViewRenderEvent.FogDensity event) {
        CommonArmorHandler handler;
        if (event.getInfo().func_216771_k().func_206884_a(FluidTags.field_206959_a) && event.getInfo().func_216773_g() instanceof PlayerEntity && (handler = CommonArmorHandler.getHandlerForPlayer()).isArmorReady(EquipmentSlotType.HEAD) && handler.isScubaEnabled() && handler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.SCUBA) > 0) {
            event.setDensity(0.02f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void guiContainerForeground(GuiContainerEvent.DrawForeground event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof IExtraGuiHandling) {
            ((IExtraGuiHandling)Minecraft.func_71410_x().field_71462_r).drawExtras(event);
        }
        RenderSystem.disableTexture();
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        ContainerScreen container = event.getGuiContainer();
        for (Slot s : container.func_212873_a_().field_75151_b) {
            int yOff;
            ICustomDurabilityBar custom;
            if (!(s.func_75211_c().func_77973_b() instanceof ICustomDurabilityBar) || !(custom = (ICustomDurabilityBar)s.func_75211_c().func_77973_b()).shouldShowCustomDurabilityBar(s.func_75211_c())) continue;
            int x = s.field_75223_e;
            int y = s.field_75221_f;
            float width = custom.getCustomDurability(s.func_75211_c()) * 13.0f;
            int[] cols = RenderUtils.decomposeColor(custom.getCustomDurabilityColour(s.func_75211_c()));
            int n = yOff = custom.isShowingOtherBar(s.func_75211_c()) ? 0 : 1;
            if (yOff == 1) {
                GuiUtils.drawUntexturedQuad(bb, x + 2, y + 14, 233.0, width, 1, 40, 40, 40, 255);
            }
            GuiUtils.drawUntexturedQuad(bb, x + 2, y + 12 + yOff, 233.0, 13.0, 1, 0, 0, 0, 255);
            GuiUtils.drawUntexturedQuad(bb, x + 2, y + 12 + yOff, 233.0, width, 1, cols[1], cols[2], cols[3], 255);
        }
        RenderSystem.enableTexture();
    }

    @SubscribeEvent
    public static void handleResolutionChange(GuiScreenEvent.InitGuiEvent event) {
        MainWindow mw;
        Screen gui = event.getGui();
        if (gui.getMinecraft().field_71441_e != null && ((mw = gui.getMinecraft().func_228018_at_()).func_198107_o() != lastWidth || mw.func_198087_p() != lastHeight)) {
            HUDHandler.instance().onResolutionChanged();
            lastWidth = mw.func_198107_o();
            lastHeight = mw.func_198087_p();
        }
    }

    public static Pair<Integer, Integer> getScaledScreenSize() {
        return Pair.of((Object)lastWidth, (Object)lastHeight);
    }
}

