/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.IBlocks;

public class SolidCoolantCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "solid.coolants");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public SolidCoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)IBlocks.DRY_ICE));
        this.localizedName = I18n.func_135052_a((String)"gui.powah.jei.category.solid.coolant", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.stack);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 3, 4);
        itemStacks.set(ingredients);
    }

    public void draw(Recipe recipe, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_211126_b(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"info.lollipop.amount", (Object[])new Object[]{"" + TextFormatting.RESET + recipe.amount}), 30.0f, 3.0f, 0x555555);
        minecraft.field_71466_p.func_211126_b(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"info.lollipop.temperature", (Object[])new Object[]{"" + TextFormatting.RESET + recipe.coldness}), 30.0f, 15.0f, 43690);
    }

    public static class Recipe {
        private final ItemStack stack;
        private final int amount;
        private final int coldness;

        public Recipe(ItemStack stack, int amount, int coldness) {
            this.stack = stack;
            this.amount = amount;
            this.coldness = coldness;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getAmount() {
            return this.amount;
        }

        public int getColdness() {
            return this.coldness;
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            allItemStacks.forEach(stack -> {
                if (PowahAPI.SOLID_COOLANTS.containsKey(stack.func_77973_b().getRegistryName())) {
                    Pair<Integer, Integer> pr = PowahAPI.getSolidCoolant((IItemProvider)stack.func_77973_b());
                    recipes.add(new Recipe((ItemStack)stack, (Integer)pr.getLeft(), (Integer)pr.getRight()));
                }
            });
            return recipes;
        }
    }
}

