/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.init.ModItems;
import xreliquary.items.SojournerStaffItem;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;

public class LanternOfParanoiaItem
extends ToggleableItem {
    private static final Map<String, Block> TORCH_BLOCKS = new HashMap<String, Block>();

    public LanternOfParanoiaItem() {
        super("lantern_of_paranoia", new Item.Properties().func_200917_a(1));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    public int getRange() {
        return (Integer)Settings.COMMON.items.lanternOfParanoia.placementScanRadius.get();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!this.isEnabled(stack) || world.field_72995_K) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos.func_218281_b((BlockPos)player.func_180425_c().func_177982_a(-this.getRange(), -this.getRange() / 2, -this.getRange()), (BlockPos)player.func_180425_c().func_177982_a(this.getRange(), this.getRange() / 2, this.getRange())).anyMatch(pos -> {
                int lightLevel = player.field_70170_p.func_226658_a_(LightType.BLOCK, pos);
                if (lightLevel > (Integer)Settings.COMMON.items.lanternOfParanoia.minLightLevel.get()) {
                    return false;
                }
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP);
                if (block instanceof FlowingFluidBlock || !block.isAir(state, (IBlockReader)world, pos) && !state.func_196953_a(BlockItemUseContext.func_221536_a((BlockItemUseContext)context, (BlockPos)pos, (Direction)Direction.DOWN))) {
                    return false;
                }
                return this.tryToPlaceTorchAround(stack, (BlockPos)pos, player, world);
            });
        }
    }

    private boolean isBlockBlockingView(World world, PlayerEntity player, BlockPos pos) {
        double playerEyeHeight = player.func_226278_cu_() + (double)player.func_70047_e();
        for (float xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    Vec3d rayTraceVector;
                    Vec3d playerVec = new Vec3d(player.func_226277_ct_() + (double)xOff, playerEyeHeight + (double)yOff, player.func_226281_cx_() + (double)zOff);
                    BlockRayTraceResult rayTraceResult = world.func_217299_a(new RayTraceContext(playerVec, rayTraceVector = new Vec3d((Vec3i)pos).func_72441_c(0.5 + (double)xOff, 0.5 + (double)yOff, 0.5 + (double)zOff), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
                    if (rayTraceResult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean tryToPlaceTorchAround(ItemStack stack, BlockPos pos, PlayerEntity player, World world) {
        if (this.isBlockBlockingView(world, player, pos)) {
            return false;
        }
        for (String torchRegistryName : (List)Settings.COMMON.items.sojournerStaff.torches.get()) {
            Block torch = this.getTorchBlock(torchRegistryName);
            if (!this.tryToPlaceTorchBlock(stack, pos, player, world, torch)) continue;
            return true;
        }
        return false;
    }

    private boolean tryToPlaceTorchBlock(ItemStack stack, BlockPos pos, PlayerEntity player, World world, Block torch) {
        if (torch.func_176223_P().func_196955_c((IWorldReader)world, pos)) {
            ArrayList trySides = Lists.newArrayList((Object[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
            ItemStack torchStack = new ItemStack((IItemProvider)torch);
            for (Direction side : trySides) {
                BlockState torchBlockState = this.getTorchSideAttempt(world, torch, pos, side);
                if (!world.func_226663_a_(torchBlockState, pos, ISelectionContext.func_216377_a()) || !InventoryHelper.consumeItem(torchStack, player, 0, 1) && !this.findAndDrainSojournersStaff(player, torch) || !this.placeBlockAt(stack, player, world, pos, torchBlockState)) continue;
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, gauss, gauss, 0.0);
                SoundType torchSoundType = torch.getSoundType(torchBlockState, (IWorldReader)world, pos, null);
                world.func_184133_a(null, pos, torchSoundType.func_185844_d(), SoundCategory.BLOCKS, (torchSoundType.func_185843_a() + 1.0f) / 2.0f, torchSoundType.func_185847_b() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private boolean findAndDrainSojournersStaff(PlayerEntity player, Block torch) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            if (player.field_71071_by.func_70301_a(slot).func_77973_b() != ModItems.SOJOURNER_STAFF || !SojournerStaffItem.removeItemFromInternalStorage(player.field_71071_by.func_70301_a(slot), torch.getRegistryName().toString(), 1, player)) continue;
            return true;
        }
        return false;
    }

    private Block getTorchBlock(String registryName) {
        if (!TORCH_BLOCKS.containsKey(registryName)) {
            TORCH_BLOCKS.put(registryName, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName)));
        }
        return TORCH_BLOCKS.get(registryName);
    }

    private BlockState getTorchSideAttempt(World world, Block torch, BlockPos pos, Direction side) {
        BlockPos facingPos = pos.func_177972_a(side);
        return torch.getStateForPlacement(torch.func_176223_P(), side, world.func_180495_p(facingPos), (IWorld)world, pos, facingPos, Hand.MAIN_HAND);
    }

    private boolean placeBlockAt(ItemStack stack, PlayerEntity player, World world, BlockPos pos, BlockState torchBlockState) {
        if (!world.func_180501_a(pos, torchBlockState, 3)) {
            return false;
        }
        torchBlockState.func_177230_c().func_180633_a(world, pos, torchBlockState, (LivingEntity)player, stack);
        return true;
    }
}

