/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.selection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.DefaultEntry;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.selection.ComponentGroup;
import vswe.stevesfactory.ui.manager.selection.IComponentChoice;
import vswe.stevesfactory.ui.manager.selection.SelectionPanel;

public class GroupComponentChoice
extends AbstractWidget
implements IComponentChoice,
LeafWidgetMixin {
    private ComponentGroup group;

    public GroupComponentChoice(ComponentGroup group) {
        super(0, 0, 16, 16);
        this.group = group;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        this.renderBackground(mouseX, mouseY);
        RenderingHelper.drawCompleteTexture(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteXRight(), this.getAbsoluteYBottom(), this.getIcon());
        if (this.isInside(mouseX, mouseY)) {
            WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)this.group.getTranslationKey(), (Object[])new Object[0]), mouseX, mouseY);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ContextMenu contextMenu;
        if (this.group.getMembers().isEmpty()) {
            contextMenu = ContextMenu.atCursor(this.getAbsoluteXRight() + 2, this.getAbsoluteY(), (List<? extends IEntry>)ImmutableList.of((Object)new DefaultEntry(null, "gui.sfm.FactoryManager.Selection.NoComponentGroupsPresent")));
            WidgetScreen.getCurrent().addPopupWindow(contextMenu);
        } else {
            ArrayList<CallbackEntry> entries = new ArrayList<CallbackEntry>();
            for (IProcedureType<?> type : this.group.getMembers()) {
                entries.add(new CallbackEntry(type.getIcon(), type.getLocalizedName(), b -> this.createFlowComponent(type)));
            }
            contextMenu = ContextMenu.atCursor(this.getAbsoluteXRight() + 2, this.getAbsoluteY(), entries);
        }
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
        this.getWindow().setFocusedWidget(this);
        return true;
    }

    public ResourceLocation getIcon() {
        return this.group.getIcon();
    }

    @Override
    @Nonnull
    public SelectionPanel getParentWidget() {
        return Objects.requireNonNull((SelectionPanel)super.getParentWidget());
    }

    @Override
    public EditorPanel getEditorPanel() {
        return this.getParentWidget().getParentWidget().editorPanel;
    }
}

