/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.ConnectionNodes;
import vswe.stevesfactory.ui.manager.editor.ConnectionsPanel;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.EndNode;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.ui.manager.editor.IntermediateNode;
import vswe.stevesfactory.ui.manager.editor.ShadowNode;

public final class StartNode
extends AbstractIconButton
implements INode {
    public static final TextureWrapper OUTPUT_NORMAL = TextureWrapper.ofFlowComponent(18, 45, 7, 6);
    public static final TextureWrapper OUTPUT_HOVERED = OUTPUT_NORMAL.toRight(1);
    private INode next;
    private EndNode end;
    private final int index;
    private final ShadowNode shadow;

    public StartNode(int index) {
        super(0, 0, 7, 6);
        this.index = index;
        this.shadow = new ShadowNode(this);
        FactoryManagerGUI.getActiveGUI().getTopLevel().connectionsPanel.addChildren(this.shadow);
    }

    @Override
    public void onParentPositionChanged() {
        super.onParentPositionChanged();
        this.updateShadowPosition();
    }

    @Override
    public void onRelativePositionChanged() {
        super.onRelativePositionChanged();
        this.updateShadowPosition();
    }

    private void updateShadowPosition() {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        int x = this.getAbsoluteX() - editor.getAbsoluteX();
        int y = this.getAbsoluteY() - editor.getAbsoluteY();
        this.shadow.setLocation(x, y);
    }

    @Override
    public void onRemoved() {
        FactoryManagerGUI.getActiveGUI().getTopLevel().connectionsPanel.removeChildren(this.shadow);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.getWindow().setFocusedWidget(this);
                return true;
            }
            case 1: {
                ConnectionsPanel.removeConnection(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.next != null) {
            IntermediateNode.dragOutIntermediateNode(this, this.next, (int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isFocused()) {
            FactoryManagerGUI.getActiveGUI().getTopLevel().connectionsPanel.onTerminalNodeClick((Either<StartNode, EndNode>)Either.left((Object)this), button);
            return true;
        }
        return false;
    }

    @Override
    public void connectTo(INode next) {
        this.next = next;
        if (next instanceof EndNode) {
            this.end = (EndNode)next;
        }
    }

    @Override
    public void connectFrom(INode previous) {
    }

    @Override
    public void disconnectNext() {
        if (this.next == this.end) {
            this.end = null;
        }
        this.next = null;
    }

    @Override
    public void disconnectPrevious() {
    }

    @Override
    @Nullable
    public INode getPrevious() {
        return null;
    }

    @Override
    @Nullable
    public INode getNext() {
        return this.next;
    }

    @Override
    public TextureWrapper getTextureNormal() {
        return OUTPUT_NORMAL;
    }

    @Override
    public TextureWrapper getTextureHovered() {
        return OUTPUT_HOVERED;
    }

    public boolean isConnected() {
        return this.end != null;
    }

    @Override
    public INode.Type getType() {
        return INode.Type.START;
    }

    public int getIndex() {
        return this.index;
    }

    public EndNode getEnd() {
        return this.end;
    }

    @Override
    @Nonnull
    public ConnectionNodes<?> getParentWidget() {
        return (ConnectionNodes)Objects.requireNonNull(super.getParentWidget());
    }

    public FlowComponent<?> getFlowComponent() {
        return (FlowComponent)((AbstractWidget)this.getParentWidget()).getParentWidget();
    }

    public IProcedure getProcedure() {
        return this.getFlowComponent().getProcedure();
    }
}

