/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.Tag;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.logic.FilterType;
import vswe.stevesfactory.logic.item.IItemFilter;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.Utils;

public class ItemTagFilter
implements IItemFilter {
    private static int TYPE_ID = IItemFilter.ItemFilters.allocateID(ItemTagFilter::recover);
    public FilterType type = FilterType.WHITELIST;
    public int stackLimit;
    private Set<Tag<Item>> tags = new HashSet<Tag<Item>>();
    private boolean matchingAmount;

    public Set<Tag<Item>> getTags() {
        return this.tags;
    }

    @Override
    public FilterType getType() {
        return this.type;
    }

    @Override
    public void setType(FilterType type) {
        this.type = type;
    }

    @Override
    public boolean isMatchingAmount() {
        return this.matchingAmount;
    }

    @Override
    public void setMatchingAmount(boolean matchingAmount) {
        this.matchingAmount = matchingAmount;
    }

    @Override
    public boolean test(ItemStack stack) {
        for (Tag<Item> tag : this.tags) {
            if (!tag.func_199685_a_((Object)stack.func_77973_b())) continue;
            return !this.getTypeFlag();
        }
        return this.getTypeFlag();
    }

    @Override
    public void extractFromInventory(IItemHandler handler, List<ItemStack> target, boolean merge) {
        if (merge) {
            this.extractFromInventoryMerge(target, handler);
        } else {
            this.extractFromInventoryNoMerge(target, handler);
        }
    }

    @Override
    public void extractFromInventory(IItemHandler handler, BiConsumer<ItemStack, Integer> receiver) {
        int total = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (this.test(stack)) {
                int need = Math.min(stack.func_190916_E(), this.stackLimit - total);
                total += need;
                stack.func_190920_e(need);
                receiver.accept(stack, i);
            }
            if (total >= this.stackLimit) break;
        }
    }

    private void extractFromInventoryNoMerge(List<ItemStack> target, IItemHandler handler) {
        int total = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (this.test(stack)) {
                int need = Math.min(stack.func_190916_E(), this.stackLimit - total);
                total += need;
                stack.func_190920_e(need);
                target.add(stack);
            }
            if (total >= this.stackLimit) break;
        }
    }

    private void extractFromInventoryMerge(List<ItemStack> target, IItemHandler handler) {
        int total = 0;
        HashMap<Item, ItemStack> results = new HashMap<Item, ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (this.test(stack)) {
                Item item = stack.func_77973_b();
                int need = Math.min(stack.func_190916_E(), this.stackLimit - total);
                total += need;
                stack.func_190920_e(need);
                if (results.containsKey(item)) {
                    ItemStack result = (ItemStack)results.get(item);
                    result.func_190917_f(stack.func_190916_E());
                } else {
                    results.put(item, stack);
                }
            }
            if (total >= this.stackLimit) break;
        }
        for (Map.Entry entry : results.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            target.add(stack);
        }
    }

    @Override
    public int limitFlowRate(ItemStack buffered, int existingCount) {
        return Utils.lowerBound(this.stackLimit - existingCount, 0);
    }

    private boolean getTypeFlag() {
        switch (this.type) {
            case WHITELIST: {
                return false;
            }
            case BLACKLIST: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTypeID() {
        return TYPE_ID;
    }

    @Override
    public void read(CompoundNBT tag) {
        this.type = tag.func_74767_n("Blacklist") ? FilterType.BLACKLIST : FilterType.WHITELIST;
        this.matchingAmount = tag.func_74767_n("MatchAmount");
        this.stackLimit = tag.func_74762_e("StackLimit");
        this.tags.clear();
        IOHelper.readItemTags(tag.func_150295_c("ItemTags", 8), this.tags);
    }

    @Override
    public void write(CompoundNBT tag) {
        tag.func_74757_a("Blacklist", this.type == FilterType.BLACKLIST);
        tag.func_74757_a("MatchAmount", this.matchingAmount);
        tag.func_74768_a("StackLimit", this.stackLimit);
        tag.func_218657_a("ItemTags", (INBT)IOHelper.writeTags(this.tags));
    }

    public static ItemTagFilter recover(CompoundNBT tag) {
        ItemTagFilter filter = new ItemTagFilter();
        filter.read(tag);
        return filter;
    }
}

