/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.top;

import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import me.desht.modularrouters.client.render.RenderHelper;
import me.desht.modularrouters.integration.top.TOPCompatibility;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.Validate;

public class ElementModule
implements IElement {
    private static final String ARROWS = " \u25bc\u25b2\u25c0\u25b6\u25a3\u25a4";
    private final ItemStack stack;
    private final ItemModule.RelativeDirection dir;

    public ElementModule(ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemModule), (String)"provided item stack is not an ItemModule!", (Object[])new Object[0]);
        this.stack = stack;
        this.dir = ModuleHelper.getDirectionFromNBT(stack);
    }

    public ElementModule(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.stack = pb.func_150791_c();
        this.dir = ItemModule.RelativeDirection.values()[pb.readByte()];
    }

    public void render(int x, int y) {
        String dirStr = String.valueOf(ARROWS.charAt(this.dir.ordinal()));
        RenderHelper.renderItemStack(Minecraft.func_71410_x(), this.stack, x + (this.getWidth() - 18) / 2, y + (this.getHeight() - 18) / 2, dirStr);
    }

    public int getWidth() {
        return 20;
    }

    public int getHeight() {
        return 20;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_150788_a(this.stack);
        pb.writeByte(this.dir.ordinal());
    }

    public int getID() {
        return TOPCompatibility.ELEMENT_MODULE_ITEM;
    }
}

