/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public abstract class CamouflagingModel
implements IDynamicBakedModel {
    private final IBakedModel baseModel;

    CamouflagingModel(IBakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        if (state == null || !(state.func_177230_c() instanceof BlockCamo)) {
            return this.baseModel.getQuads(state, side, rand, modelData);
        }
        BlockState camoState = (BlockState)modelData.getData(BlockCamo.CAMOUFLAGE_STATE);
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            layer = RenderType.func_228639_c_();
        }
        if (camoState == null && layer == RenderType.func_228639_c_()) {
            return this.baseModel.getQuads(state, side, rand, modelData);
        }
        if (camoState != null && RenderTypeLookup.canRenderInLayer((BlockState)camoState, (RenderType)layer)) {
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(camoState);
            return model.getQuads(camoState, side, rand, modelData);
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    public boolean func_230044_c_() {
        return false;
    }

    static class TemplateFrameModel
    extends CamouflagingModel {
        TemplateFrameModel(IBakedModel baseModel) {
            super(baseModel);
        }
    }

    static class RouterModel
    extends CamouflagingModel {
        RouterModel(IBakedModel baseModel) {
            super(baseModel);
        }
    }
}

