/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class Starter
implements IDataProvider {
    private static final Starter INSTANCE = new Starter();
    private static final Logger LOGGER = LogManager.getLogger((String)"QuarryPlus/TestExecutor");
    private static final Marker MARKER = MarkerManager.getMarker((String)"QUARRYPLUS_TEST");

    public static Starter getInstance() {
        return INSTANCE;
    }

    public static void startTest() {
        LOGGER.info("Hello test");
        LOGGER.info("---------- System properties ----------");
        System.getProperties().stringPropertyNames().stream().sorted().map(MapStreamSyntax.toEntry(Function.identity(), System.getProperties()::getProperty)).map(MapStreamSyntax.toAny((k, v) -> k + "=" + v)).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        LOGGER.info("---------- Env ----------");
        System.getenv().entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(MapStreamSyntax.byKey(s -> !s.toLowerCase().contains("token"))).map(MapStreamSyntax.toAny((s, s2) -> s + "=" + s2)).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)"com.kotori316.test_qp"), DiscoverySelectors.selectPackage((String)Starter.class.getPackage().getName())}).build();
        if (Starter.isInCI()) {
            try {
                Files.createFile(Paths.get("..", "test_started.txt"), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("File IO", (Throwable)e);
            }
        }
        Launcher launcher = LauncherFactory.create();
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        launcher.execute(request, new TestExecutionListener[0]);
        TestExecutionSummary summary = listener.getSummary();
        StringWriter stream = new StringWriter();
        summary.printTo(new PrintWriter(stream));
        LOGGER.info(stream.toString());
        List<Throwable> errors = summary.getFailures().stream().map(TestExecutionSummary.Failure::getException).collect(Collectors.toList());
        errors.forEach(t -> LOGGER.fatal(MARKER, "Test failed.", t));
        if (Starter.isInCI() && !errors.isEmpty()) {
            try (BufferedWriter w = Files.newBufferedWriter(Paths.get("..", "error-trace.txt"), new OpenOption[0]);
                 PrintWriter writer = new PrintWriter(w);){
                errors.forEach(t -> t.printStackTrace(writer));
            }
            catch (IOException e) {
                LOGGER.error("File IO", (Throwable)e);
            }
        }
    }

    private static boolean isInCI() {
        return Boolean.parseBoolean(System.getenv("GITHUB_ACTIONS"));
    }

    public void func_200398_a(DirectoryCache cache) {
        Starter.startTest();
    }

    public String func_200397_b() {
        return "QuarryPlus Test";
    }
}

