/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.quarry;

import com.yogpc.qp.machines.quarry.TileBasic;
import com.yogpc.qp.packet.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class LevelMessage
implements IMessage<LevelMessage> {
    protected int yLevel;
    protected BlockPos pos;
    protected int dim;

    public static LevelMessage create(TileBasic tileBasic) {
        LevelMessage message = new LevelMessage();
        message.yLevel = tileBasic.yLevel;
        message.pos = tileBasic.func_174877_v();
        message.dim = IMessage.getDimId(tileBasic.func_145831_w());
        return message;
    }

    @Override
    public LevelMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.yLevel = buffer.readInt();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.writeInt(this.yLevel);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, TileBasic.class).ifPresent(tile -> {
            switch (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide()) {
                case CLIENT: {
                    tile.setYLevel(this.yLevel);
                    break;
                }
                case SERVER: {
                    ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> tile.setYLevel(this.yLevel));
                }
            }
        });
    }
}

