/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.pipe.transport;

import com.raoulvdberge.refinedpipes.util.DirectionUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class ItemTransportProps {
    private final ItemStack stack;
    private final int maxTicksInPipe;
    private int progress;
    private final Direction direction;
    private final Direction initialDirection;
    private final boolean lastPipe;
    private final boolean firstPipe;

    public ItemTransportProps(ItemStack stack, int maxTicksInPipe, int progress, Direction direction, Direction initialDirection, boolean lastPipe, boolean firstPipe) {
        this.stack = stack;
        this.maxTicksInPipe = maxTicksInPipe;
        this.progress = progress;
        this.direction = direction;
        this.initialDirection = initialDirection;
        this.lastPipe = lastPipe;
        this.firstPipe = firstPipe;
    }

    public void writeToBuffer(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeInt(this.maxTicksInPipe);
        buf.writeInt(this.progress);
        buf.writeInt(this.direction.ordinal());
        buf.writeInt(this.initialDirection.ordinal());
        buf.writeBoolean(this.lastPipe);
        buf.writeBoolean(this.firstPipe);
    }

    public static ItemTransportProps create(PacketBuffer buf) {
        return new ItemTransportProps(buf.func_150791_c(), buf.readInt(), buf.readInt(), DirectionUtil.safeGet((byte)buf.readInt()), DirectionUtil.safeGet((byte)buf.readInt()), buf.readBoolean(), buf.readBoolean());
    }

    public void tick() {
        ++this.progress;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getMaxTicksInPipe() {
        return this.maxTicksInPipe;
    }

    public int getProgress() {
        return this.progress;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Direction getInitialDirection() {
        return this.initialDirection;
    }

    public boolean isLastPipe() {
        return this.lastPipe;
    }

    public boolean isFirstPipe() {
        return this.firstPipe;
    }
}

