/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.energy;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.energy.EnergyStorage;
import com.raoulvdberge.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.raoulvdberge.refinedpipes.network.pipe.Destination;
import com.raoulvdberge.refinedpipes.network.pipe.DestinationType;
import com.raoulvdberge.refinedpipes.network.pipe.energy.EnergyPipe;
import com.raoulvdberge.refinedpipes.network.pipe.energy.EnergyPipeType;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyNetwork
extends Network {
    private final EnergyStorage energyStorage;
    private final EnergyPipeType pipeType;

    public EnergyNetwork(BlockPos originPos, String id, EnergyPipeType pipeType) {
        super(originPos, id);
        this.pipeType = pipeType;
        this.energyStorage = new EnergyStorage(0);
        this.energyStorage.setMaxReceive(pipeType.getCapacity());
    }

    @Override
    public NetworkGraphScannerResult scanGraph(World world, BlockPos pos) {
        NetworkGraphScannerResult result = super.scanGraph(world, pos);
        this.energyStorage.setCapacityAndMaxExtract(result.getFoundPipes().stream().filter(p -> p instanceof EnergyPipe).mapToInt(p -> ((EnergyPipe)p).getType().getCapacity()).sum());
        if (this.energyStorage.getEnergyStored() > this.energyStorage.getMaxEnergyStored()) {
            this.energyStorage.setStored(this.energyStorage.getMaxEnergyStored());
        }
        return result;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void update(World world) {
        super.update(world);
        List<Destination> destinations = this.graph.getDestinations(DestinationType.ENERGY_STORAGE);
        if (!destinations.isEmpty()) {
            if (this.energyStorage.getEnergyStored() <= 0) {
                return;
            }
            for (Destination destination : destinations) {
                IEnergyStorage handler;
                TileEntity tile = destination.getConnectedPipe().getWorld().func_175625_s(destination.getReceiver());
                if (tile == null || (handler = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, destination.getIncomingDirection().func_176734_d()).orElse(null)) == null || !handler.canReceive()) continue;
                int toOffer = Math.min(this.pipeType.getTransferRate(), this.energyStorage.getEnergyStored());
                if (toOffer <= 0 || (toOffer = this.energyStorage.extractEnergy(toOffer, false)) <= 0) break;
                int accepted = handler.receiveEnergy(toOffer, false);
                int remainder = toOffer - accepted;
                if (remainder <= 0) continue;
                this.energyStorage.receiveEnergy(remainder, false);
            }
        }
    }

    @Override
    public void onMergedWith(Network mainNetwork) {
        ((EnergyNetwork)mainNetwork).energyStorage.receiveEnergy(this.energyStorage.getEnergyStored(), false);
    }

    @Override
    public ResourceLocation getType() {
        return this.pipeType.getNetworkType();
    }

    public EnergyPipeType getPipeType() {
        return this.pipeType;
    }
}

