/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolscontrol.modules.processor.network.PacketLogReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetLog {
    protected BlockPos pos;
    protected DimensionType type;
    protected TypedMap params;
    private boolean fromTablet;

    public PacketGetLog(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.type = DimensionType.func_186069_a((int)buf.readInt());
        this.params = TypedMapTools.readArguments((PacketBuffer)buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetLog(DimensionType type, BlockPos pos, boolean fromTablet) {
        this.pos = pos;
        this.type = type;
        this.params = TypedMap.EMPTY;
        this.fromTablet = fromTablet;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.type.func_186068_a());
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerWorld world = WorldTools.getWorld((World)ctx.getSender().func_130014_f_(), (DimensionType)this.type);
            TileEntity te = world.func_175625_s(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList("getLog", this.params, Type.STRING);
            if (this.fromTablet) {
                RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(null, "getLog", list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            } else {
                RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(this.pos, "getLog", list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

