/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class IntegerEditor
extends AbstractParameterEditor {
    private TextField field;
    private ToggleButton hexMode;

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.field = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        this.hexMode = (ToggleButton)new ToggleButton().event(this::updateHex).checkMarker(true).text("Hex");
        constantPanel.children(new Widget[]{this.field, this.hexMode});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_INTEGER);
    }

    private void updateHex() {
        Integer i;
        String value = this.field.getText();
        if (this.hexMode.isPressed()) {
            if (!value.startsWith("$")) {
                try {
                    int i2 = Integer.parseInt(value);
                    value = "$" + Integer.toHexString(i2);
                    this.field.text(value);
                }
                catch (NumberFormatException i2) {}
            }
        } else if (value.startsWith("$") && (i = IntegerEditor.parseIntSafe(value)) != null) {
            this.field.text(String.valueOf(i));
        }
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)IntegerEditor.parseIntSafe(this.field.getText()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.text("");
        } else {
            try {
                this.field.text(Integer.toString((Integer)value.getValue()));
            }
            catch (Exception e) {
                this.field.text("");
            }
        }
        this.updateHex();
    }
}

