/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.FluidTools;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.LogicInventoryTools;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class TypeConverters {
    public static float convertToFloat(IParameter value) {
        if (value == null) {
            return 0.0f;
        }
        if (!value.isSet()) {
            return 0.0f;
        }
        Object v = value.getParameterValue().getValue();
        switch (value.getParameterType()) {
            case PAR_STRING: {
                return Float.parseFloat((String)v);
            }
            case PAR_INTEGER: {
                return ((Integer)v).floatValue();
            }
            case PAR_LONG: {
                return ((Long)v).floatValue();
            }
            case PAR_FLOAT: {
                return ((Float)v).floatValue();
            }
            case PAR_NUMBER: {
                return TypeConverters.castToFloat(v);
            }
            case PAR_BOOLEAN: {
                return (Boolean)v != false ? 1.0f : 0.0f;
            }
            case PAR_ITEM: {
                return ((ItemStack)v).func_190916_E();
            }
            case PAR_FLUID: {
                return ((FluidStack)v).getAmount();
            }
        }
        return 0.0f;
    }

    @Nullable
    public static FluidStack convertToFluid(IParameter parameter) {
        if (parameter == null) {
            return null;
        }
        return TypeConverters.convertToFluid(parameter.getParameterType(), parameter.getParameterValue().getValue());
    }

    @Nullable
    public static FluidStack convertToFluid(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_STRING: {
                return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation((String)v)), 1);
            }
            case PAR_FLUID: {
                return (FluidStack)v;
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)v;
                return (FluidStack)FluidUtil.getFluidContained((ItemStack)itemStack).map(f -> f).orElse((Object)FluidStack.EMPTY);
            }
        }
        return null;
    }

    @Nonnull
    public static ItemStack convertToItem(IParameter value) {
        if (value == null) {
            return ItemStack.field_190927_a;
        }
        return TypeConverters.convertToItem(value.getParameterType(), value.getParameterValue().getValue());
    }

    @Nonnull
    public static ItemStack convertToItem(ParameterType type, Object v) {
        if (v == null) {
            return ItemStack.field_190927_a;
        }
        switch (type) {
            case PAR_STRING: {
                return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)v)), 1);
            }
            case PAR_ITEM: {
                return (ItemStack)v;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)v;
                return FluidTools.convertFluidToBucket((FluidStack)fluidStack);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static Inventory convertToInventory(IParameter par) {
        if (par == null) {
            return null;
        }
        return TypeConverters.convertToInventory(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nullable
    public static Inventory convertToInventory(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_INVENTORY: {
                return (Inventory)v;
            }
            case PAR_SIDE: {
                BlockSide bs = (BlockSide)v;
                if (bs.getSide() == null) {
                    throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                }
                return new Inventory(bs.getNodeName(), bs.getSide(), null);
            }
            case PAR_STRING: {
                return LogicInventoryTools.inventoryFromString(v.toString());
            }
        }
        return null;
    }

    @Nullable
    public static BlockSide convertToSide(IParameter par) {
        if (par == null) {
            return null;
        }
        return TypeConverters.convertToSide(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nullable
    public static BlockSide convertToSide(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_SIDE: {
                return (BlockSide)v;
            }
            case PAR_INVENTORY: {
                return (Inventory)v;
            }
            case PAR_STRING: {
                return LogicInventoryTools.blockSideFromString(v.toString());
            }
        }
        return null;
    }

    @Nullable
    public static Tuple convertToTuple(IParameter value) {
        if (value == null || value.getParameterValue() == null) {
            return null;
        }
        return TypeConverters.convertToTuple(value.getParameterType(), value.getParameterValue().getValue());
    }

    @Nullable
    public static Tuple convertToTuple(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_TUPLE: {
                return (Tuple)v;
            }
            case PAR_VECTOR: {
                break;
            }
            case PAR_STRING: {
                String s = (String)v;
                String[] split = StringUtils.split((String)s, (char)',');
                int x = Integer.parseInt(split[0]);
                int y = Integer.parseInt(split[1]);
                return new Tuple(x, y);
            }
        }
        return null;
    }

    @Nullable
    public static List<Parameter> convertToVector(IParameter value) {
        if (value == null || value.getParameterValue() == null) {
            return null;
        }
        return TypeConverters.convertToVector(value.getParameterType(), value.getParameterValue().getValue());
    }

    @Nullable
    public static List<Parameter> convertToVector(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_VECTOR: {
                return (List)v;
            }
        }
        return null;
    }

    public static boolean convertToBool(IParameter value) {
        if (value == null) {
            return false;
        }
        return TypeConverters.convertToBool(value.getParameterType(), value.getParameterValue().getValue());
    }

    public static boolean convertToBool(ParameterType type, Object v) {
        if (v == null) {
            return false;
        }
        switch (type) {
            case PAR_STRING: {
                return !((String)v).isEmpty();
            }
            case PAR_INTEGER: {
                return (Integer)v != 0;
            }
            case PAR_LONG: {
                return (Long)v != 0L;
            }
            case PAR_FLOAT: {
                return ((Float)v).floatValue() != 0.0f;
            }
            case PAR_NUMBER: {
                return TypeConverters.castToInt(v) != 0;
            }
            case PAR_BOOLEAN: {
                return (Boolean)v;
            }
            case PAR_TUPLE: {
                return ((Tuple)v).getX() != 0 || ((Tuple)v).getY() != 0;
            }
            case PAR_VECTOR: {
                return !((List)v).isEmpty();
            }
            case PAR_ITEM: {
                return !((ItemStack)v).func_190926_b();
            }
            case PAR_FLUID: 
            case PAR_INVENTORY: 
            case PAR_SIDE: 
            case PAR_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    public static int convertToInt(IParameter value) {
        if (value == null) {
            return 0;
        }
        Integer integer = TypeConverters.convertToInteger(value.getParameterType(), value.getParameterValue().getValue());
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static long convertToLong(IParameter value) {
        if (value == null) {
            return 0L;
        }
        Long l = TypeConverters.convertToLong(value.getParameterType(), value.getParameterValue().getValue());
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Nonnull
    public static Number convertToNumber(IParameter value) {
        if (value == null) {
            return 0;
        }
        Number l = TypeConverters.convertToNumber(value.getParameterType(), value.getParameterValue().getValue());
        if (l == null) {
            return 0;
        }
        return l;
    }

    @Nullable
    public static Integer convertToInteger(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_STRING: {
                String s = (String)v;
                if (s.startsWith("$")) {
                    return (int)Long.parseLong(s.substring(1), 16);
                }
                return Integer.parseInt(s);
            }
            case PAR_INTEGER: {
                return (Integer)v;
            }
            case PAR_LONG: {
                return ((Long)v).intValue();
            }
            case PAR_FLOAT: {
                return ((Float)v).intValue();
            }
            case PAR_NUMBER: {
                return TypeConverters.castToInt(v);
            }
            case PAR_BOOLEAN: {
                return (Boolean)v != false ? 1 : 0;
            }
            case PAR_ITEM: {
                return ((ItemStack)v).func_190916_E();
            }
            case PAR_FLUID: {
                return ((FluidStack)v).getAmount();
            }
            case PAR_VECTOR: {
                return ((List)v).size();
            }
        }
        return null;
    }

    @Nullable
    public static Long convertToLong(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_STRING: {
                String s = (String)v;
                if (s.startsWith("$")) {
                    return Long.parseLong(s.substring(1), 16);
                }
                return Long.parseLong(s);
            }
            case PAR_INTEGER: {
                return ((Integer)v).longValue();
            }
            case PAR_LONG: {
                return (Long)v;
            }
            case PAR_FLOAT: {
                return ((Float)v).longValue();
            }
            case PAR_NUMBER: {
                return TypeConverters.castToLong(v);
            }
            case PAR_BOOLEAN: {
                return (Boolean)v != false ? 1L : 0L;
            }
            case PAR_ITEM: {
                return ((ItemStack)v).func_190916_E();
            }
            case PAR_FLUID: {
                return ((FluidStack)v).getAmount();
            }
            case PAR_VECTOR: {
                return ((List)v).size();
            }
        }
        return null;
    }

    @Nullable
    public static Number convertToNumber(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_STRING: {
                String s = (String)v;
                if (s.startsWith("$")) {
                    return Long.parseLong(s.substring(1), 16);
                }
                if (s.contains(",") || s.contains(".") || s.contains("e") || s.contains("E")) {
                    return Double.parseDouble(s);
                }
                return Long.parseLong(s);
            }
            case PAR_INTEGER: 
            case PAR_LONG: 
            case PAR_FLOAT: 
            case PAR_NUMBER: {
                return (Number)v;
            }
            case PAR_BOOLEAN: {
                return (Boolean)v != false ? 1L : 0L;
            }
            case PAR_ITEM: {
                return ((ItemStack)v).func_190916_E();
            }
            case PAR_FLUID: {
                return ((FluidStack)v).getAmount();
            }
            case PAR_VECTOR: {
                return ((List)v).size();
            }
        }
        return null;
    }

    @Nonnull
    public static String convertToString(IParameter value) {
        if (value == null) {
            return "";
        }
        String s = TypeConverters.convertToString(value.getParameterType(), value.getParameterValue().getValue());
        if (s == null) {
            return "";
        }
        return s;
    }

    @Nullable
    public static String convertToString(ParameterType type, Object v) {
        if (v == null) {
            return null;
        }
        switch (type) {
            case PAR_STRING: {
                return (String)v;
            }
            case PAR_INTEGER: {
                return Integer.toString((Integer)v);
            }
            case PAR_LONG: {
                return Long.toString((Long)v);
            }
            case PAR_FLOAT: {
                return Float.toString(((Float)v).floatValue());
            }
            case PAR_NUMBER: {
                if (v instanceof Integer) {
                    return Integer.toString((Integer)v);
                }
                if (v instanceof Long) {
                    return Long.toString((Long)v);
                }
                if (v instanceof Float) {
                    return Float.toString(((Float)v).floatValue());
                }
                if (v instanceof Double) {
                    return Double.toString((Double)v);
                }
                return "?";
            }
            case PAR_BOOLEAN: {
                return (Boolean)v != false ? "true" : "false";
            }
            case PAR_ITEM: {
                if (!((ItemStack)v).func_190926_b()) {
                    return ((ItemStack)v).func_77973_b().getRegistryName().toString();
                }
                return null;
            }
            case PAR_FLUID: {
                return ((FluidStack)v).getFluid().getRegistryName().toString();
            }
            case PAR_INVENTORY: {
                return LogicInventoryTools.inventoryToString((Inventory)v);
            }
            case PAR_SIDE: {
                return LogicInventoryTools.blockSideToString((BlockSide)v);
            }
            case PAR_EXCEPTION: {
                return ((ExceptionType)((Object)v)).getCode();
            }
            case PAR_TUPLE: {
                return v.toString();
            }
            case PAR_VECTOR: {
                return TypeConverters.vectorToString((List)v, 50);
            }
        }
        return null;
    }

    private static String vectorToString(List<Parameter> v, int max) {
        StringBuilder builder = new StringBuilder(91);
        List<Parameter> vector = v;
        boolean first = true;
        for (Parameter par : vector) {
            if (!first) {
                builder.append(',');
            }
            if (builder.length() >= max) {
                builder.append("...");
                break;
            }
            builder.append(TypeConverters.convertToString(par));
            first = false;
        }
        builder.append(']');
        return builder.toString();
    }

    public static int castToInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        return 0;
    }

    public static long castToLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        return 0L;
    }

    public static float castToFloat(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        if (value instanceof Long) {
            return ((Long)value).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        return 0.0f;
    }

    public static double castToDouble(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    public static String castNumberToString(Object value) {
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        return "?";
    }

    public static String getNumberType(Object value) {
        if (value instanceof Integer) {
            return "I";
        }
        if (value instanceof Long) {
            return "L";
        }
        if (value instanceof Float) {
            return "F";
        }
        if (value instanceof Double) {
            return "D";
        }
        return "?";
    }
}

