/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;

public class LazyPartData
implements IPartData {
    private final ResourceLocation partId;
    private final MaterialGrade grade;

    public LazyPartData(ResourceLocation partId) {
        this(partId, MaterialGrade.NONE);
    }

    public LazyPartData(ResourceLocation partId, MaterialGrade grade) {
        this.partId = partId;
        this.grade = grade;
    }

    @Override
    public ResourceLocation getPartId() {
        return this.partId;
    }

    @Override
    @Nullable
    public IGearPart getPart() {
        return PartManager.get(this.partId);
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getCraftingItem() {
        IGearPart part = this.getPart();
        if (part != null) {
            return PartData.of(part).getCraftingItem();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public CompoundNBT write(CompoundNBT tags) {
        tags.func_74778_a("ID", this.partId.toString());
        if (this.grade != MaterialGrade.NONE) {
            tags.func_74778_a("Grade", this.grade.name());
        }
        return tags;
    }

    public boolean isValid() {
        return this.getPart() != null;
    }

    public static LazyPartData readJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String key = json.getAsString();
            return new LazyPartData(new ResourceLocation(key));
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String key = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"part");
        String gradeStr = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"grade", (String)MaterialGrade.NONE.name());
        MaterialGrade grade = MaterialGrade.fromString(gradeStr);
        return new LazyPartData(new ResourceLocation(key), grade);
    }

    public static List<PartData> createPartList(Collection<LazyPartData> parts) {
        return parts.stream().filter(LazyPartData::isValid).map(p -> PartData.of(p.getPart())).collect(Collectors.toList());
    }
}

