/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import com.blakebr0.cucumber.helper.RenderHelper;
import com.blakebr0.ironjetpacks.client.util.HudHelper;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HudHandler {
    private static final ResourceLocation HUD_TEXTURE = new ResourceLocation("ironjetpacks", "textures/gui/hud.png");

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && ((Boolean)ModConfigs.ENABLE_HUD.get()).booleanValue() && (((Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get()).booleanValue() || !((Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get()).booleanValue() && !(mc.field_71462_r instanceof ChatScreen)) && !mc.field_71474_y.field_74319_N && !mc.field_71474_y.field_74330_P) {
            ItemStack chest = mc.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
            Item item = chest.func_77973_b();
            if (!chest.func_190926_b() && item instanceof JetpackItem) {
                JetpackItem jetpack = (JetpackItem)item;
                HudHelper.HudPos pos = HudHelper.getHudPos();
                if (pos != null) {
                    int xPos = (int)((double)pos.x / 0.33) - 18;
                    int yPos = (int)((double)pos.y / 0.33) - 78;
                    mc.func_110434_K().func_110577_a(HUD_TEXTURE);
                    RenderSystem.pushMatrix();
                    RenderSystem.scaled((double)0.33, (double)0.33, (double)1.0);
                    RenderHelper.drawTexturedModalRect((int)xPos, (int)yPos, (int)0, (int)0, (int)28, (int)156);
                    int i2 = HudHelper.getEnergyBarScaled(jetpack, chest);
                    RenderHelper.drawTexturedModalRect((int)xPos, (int)(166 - i2 + yPos - 10), (int)28, (int)(156 - i2), (int)28, (int)i2);
                    RenderSystem.popMatrix();
                    String fuel = "\u00a77" + HudHelper.getFuel(jetpack, chest);
                    String engine = "\u00a77E: " + HudHelper.getOn(jetpack.isEngineOn(chest));
                    String hover = "\u00a77H: " + HudHelper.getOn(jetpack.isHovering(chest));
                    if (pos.side == 1) {
                        mc.field_71466_p.func_175063_a(fuel, (float)(pos.x - 8 - mc.field_71466_p.func_78256_a(fuel)), (float)(pos.y - 21), 0xF9FFFE);
                        mc.field_71466_p.func_175063_a(engine, (float)(pos.x - 8 - mc.field_71466_p.func_78256_a(engine)), (float)(pos.y + 4), 0xF9FFFE);
                        mc.field_71466_p.func_175063_a(hover, (float)(pos.x - 8 - mc.field_71466_p.func_78256_a(hover)), (float)(pos.y + 14), 0xF9FFFE);
                    } else {
                        mc.field_71466_p.func_175063_a(fuel, (float)(pos.x + 6), (float)(pos.y - 21), 0xF9FFFE);
                        mc.field_71466_p.func_175063_a(engine, (float)(pos.x + 6), (float)(pos.y + 4), 0xF9FFFE);
                        mc.field_71466_p.func_175063_a(hover, (float)(pos.x + 6), (float)(pos.y + 14), 0xF9FFFE);
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
                }
            }
        }
    }
}

