/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import me.dags.noise.Module;
import me.dags.noise.source.Builder;
import me.dags.noise.source.FastSource;
import me.dags.noise.util.NoiseUtil;

public class FastSin
extends FastSource {
    private final Module alpha;

    public FastSin(Builder builder) {
        super(builder);
        this.alpha = builder.getSource();
    }

    @Override
    public float getValue(float x, float y, int seed) {
        float noise;
        float a = this.alpha.getValue(x, y);
        x *= this.frequency;
        y *= this.frequency;
        if (a == 0.0f) {
            noise = NoiseUtil.sin(x);
        } else if (a == 1.0f) {
            noise = NoiseUtil.sin(y);
        } else {
            float sx = NoiseUtil.sin(x);
            float sy = NoiseUtil.sin(y);
            noise = NoiseUtil.lerp(sx, sy, a);
        }
        return NoiseUtil.map(noise, -1.0f, 1.0f, 2.0f);
    }
}

