/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.modifier;

import me.dags.noise.Module;

public class Cache
implements Module {
    private final Module source;
    private final Value value = new Value();

    public Cache(Module source) {
        this.source = source;
    }

    @Override
    public float minValue() {
        return this.source.minValue();
    }

    @Override
    public float maxValue() {
        return this.source.maxValue();
    }

    @Override
    public float getValue(float x, float y) {
        Value value = this.value;
        if (value.matches(x, y)) {
            return value.value;
        }
        return value.set(x, y, this.source.getValue(x, y));
    }

    private static class Value {
        private float x = 0.0f;
        private float y = 0.0f;
        private float value = 0.0f;
        private boolean empty = true;

        private Value() {
        }

        private boolean matches(float x, float y) {
            return !this.empty && x == this.x && y == this.y;
        }

        private float set(float x, float y, float value) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.empty = false;
            return value;
        }
    }
}

