/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui;

import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.element.TerraButton;
import com.terraforged.mod.gui.element.TerraLabel;
import com.terraforged.mod.gui.page.ClimatePage;
import com.terraforged.mod.gui.page.DimensionsPage;
import com.terraforged.mod.gui.page.FeaturePage;
import com.terraforged.mod.gui.page.FilterPage;
import com.terraforged.mod.gui.page.GeneratorPage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.page.RiverPage;
import com.terraforged.mod.gui.page.StructurePage;
import com.terraforged.mod.gui.page.TerrainPage;
import com.terraforged.mod.gui.preview.PreviewPage;
import com.terraforged.mod.settings.SettingsHelper;
import com.terraforged.mod.settings.TerraSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class SettingsScreen
extends OverlayScreen {
    private static final Button.IPressable NO_ACTION = b -> {};
    private final Page[] pages;
    private final PreviewPage preview;
    private final CreateWorldScreen parent;
    private final TerraSettings settings = new TerraSettings();
    private int pageIndex = 0;
    private boolean hasChanged = false;

    public SettingsScreen(CreateWorldScreen parent) {
        SettingsHelper.applyDefaults(parent.field_146334_a, this.settings);
        this.parent = parent;
        this.preview = new PreviewPage(this.settings, SettingsScreen.getSeed(parent));
        this.pages = new Page[]{new GeneratorPage(this.settings, this.preview), new ClimatePage(this.settings, this.preview), new TerrainPage(this.settings, this.preview), new RiverPage(this.settings, this.preview), new FilterPage(this.settings, this.preview), new FeaturePage(this.settings), new StructurePage(this.settings), new DimensionsPage(this.settings)};
    }

    @Override
    protected void init() {
        this.buttons.clear();
        this.children.clear();
        int buttonsCenter = this.width / 2;
        int buttonWidth = 50;
        int buttonHeight = 20;
        int buttonPad = 2;
        int buttonsRow = this.height - 25;
        if (this.pageIndex < this.pages.length) {
            Page page = this.pages[this.pageIndex];
            page.callback(() -> {
                this.hasChanged = true;
            });
            TerraLabel title = new TerraLabel(page.getTitle());
            title.visible = true;
            title.x = 16;
            title.y = 15;
            this.buttons.add(title);
            try {
                page.initPage(10, 30, this);
                this.preview.initPage(10, 30, this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.addButton(new Button(buttonsCenter - buttonWidth - buttonPad, buttonsRow, buttonWidth, buttonHeight, "Cancel", b -> this.onClose()));
        this.addButton(new Button(buttonsCenter + buttonPad, buttonsRow, buttonWidth, buttonHeight, "Done", b -> {
            for (Page page : this.pages) {
                page.save();
            }
            this.parent.field_146334_a = NBTHelper.serializeCompact(this.settings);
            SettingsScreen.setSeed(this.parent, this.preview.getSeed());
            this.onClose();
        }));
        this.addButton(new Button(buttonsCenter - (buttonWidth * 2 + buttonPad * 3), buttonsRow, buttonWidth, buttonHeight, "<<", NO_ACTION){

            public void render(int mouseX, int mouseY, float partialTicks) {
                this.active = SettingsScreen.this.hasPrevious();
                super.render(mouseX, mouseY, partialTicks);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                if (SettingsScreen.this.hasPrevious()) {
                    SettingsScreen.this.pageIndex--;
                    SettingsScreen.this.init();
                }
            }
        });
        this.addButton(new Button(buttonsCenter + buttonWidth + buttonPad * 3, buttonsRow, buttonWidth, buttonHeight, ">>", NO_ACTION){

            public void render(int mouseX, int mouseY, float partialTicks) {
                this.active = SettingsScreen.this.hasNext();
                super.render(mouseX, mouseY, partialTicks);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                if (SettingsScreen.this.hasNext()) {
                    SettingsScreen.this.pageIndex++;
                    SettingsScreen.this.init();
                }
            }
        });
        this.addButton(new TerraButton("Set Defaults", new String[]{"Use the current settings as the defaults", "CTRL + click to clear them"}){
            private boolean ctrl;
            {
                this.ctrl = false;
            }

            public void render(int mouseX, int mouseY, float partialTicks) {
                if (Screen.hasControlDown()) {
                    if (!this.ctrl) {
                        this.ctrl = true;
                        this.setMessage("Clear Defaults");
                    }
                    this.active = true;
                } else {
                    if (this.ctrl) {
                        this.ctrl = false;
                        this.setMessage("Set Defaults");
                    }
                    this.active = SettingsScreen.this.hasChanged;
                }
                super.render(mouseX, mouseY, partialTicks);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                if (Screen.hasControlDown()) {
                    SettingsHelper.clearDefaults();
                    SettingsScreen.this.hasChanged = true;
                } else {
                    for (Page page : SettingsScreen.this.pages) {
                        page.save();
                    }
                    SettingsScreen.this.hasChanged = false;
                    SettingsHelper.exportDefaults(SettingsScreen.this.settings);
                }
            }
        }.init(this.width - buttonWidth - 55, buttonsRow, 90, buttonHeight));
        super.init();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground();
        this.pages[this.pageIndex].visit(pane -> pane.render(mouseX, mouseY, partialTicks));
        this.preview.visit(pane -> pane.render(mouseX, mouseY, partialTicks));
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderOverlays(Screen screen, int mouseX, int mouseY) {
        super.renderOverlays(screen, mouseX, mouseY);
        this.pages[this.pageIndex].visit(pane -> pane.renderOverlays(screen, mouseX, mouseY));
        this.preview.visit(pane -> pane.renderOverlays(screen, mouseX, mouseY));
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseClicked(x, y, button));
        boolean b = this.preview.action(pane -> pane.mouseClicked(x, y, button));
        boolean c = super.mouseClicked(x, y, button);
        return a || b || c;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseReleased(x, y, button));
        boolean b = this.preview.action(pane -> pane.mouseReleased(x, y, button));
        boolean c = super.mouseReleased(x, y, button);
        return a || b || c;
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseDragged(x, y, button, dx, dy));
        boolean b = this.preview.action(pane -> pane.mouseDragged(x, y, button, dx, dy));
        boolean c = super.mouseDragged(x, y, button, dx, dy);
        return a || b || c;
    }

    public boolean mouseScrolled(double x, double y, double direction) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseScrolled(x, y, direction));
        boolean b = this.preview.action(pane -> pane.mouseScrolled(x, y, direction));
        boolean c = super.mouseScrolled(x, y, direction);
        return a || b || c;
    }

    public boolean keyPressed(int i, int j, int k) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.keyPressed(i, j, k));
        boolean b = this.preview.action(pane -> pane.keyPressed(i, j, k));
        boolean c = super.keyPressed(i, j, k);
        return a || b || c;
    }

    public boolean charTyped(char c, int code) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.charTyped(c, code));
        boolean b = this.preview.action(pane -> pane.charTyped(c, code));
        return a || b || super.charTyped(c, code);
    }

    public void onClose() {
        for (Page page : this.pages) {
            page.close();
        }
        this.preview.close();
        Minecraft.func_71410_x().func_147108_a((Screen)this.parent);
    }

    private boolean hasNext() {
        return this.pageIndex + 1 < this.pages.length;
    }

    private boolean hasPrevious() {
        return this.pageIndex > 0;
    }

    private static int getSeed(CreateWorldScreen screen) {
        TextFieldWidget field = SettingsScreen.getWidget(screen);
        if (field != null && !field.func_146179_b().isEmpty()) {
            try {
                long seed = Long.parseLong(field.func_146179_b());
                return (int)seed;
            }
            catch (NumberFormatException var6) {
                return field.func_146179_b().hashCode();
            }
        }
        return -1;
    }

    private static void setSeed(CreateWorldScreen screen, int seed) {
        TextFieldWidget field = SettingsScreen.getWidget(screen);
        if (field != null) {
            field.func_146180_a("" + seed);
        }
    }

    private static TextFieldWidget getWidget(CreateWorldScreen screen) {
        String message = I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]);
        for (IGuiEventListener widget : screen.children()) {
            TextFieldWidget field;
            if (!(widget instanceof TextFieldWidget) || !(field = (TextFieldWidget)widget).getMessage().equals(message)) continue;
            return field;
        }
        return null;
    }
}

