/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap.river;

import com.terraforged.core.world.rivermap.river.RiverNode;
import me.dags.noise.util.Vec2f;

public class RiverBounds {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;

    public RiverBounds(int x1, int y1, int x2, int y2, int radius) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.minX = Math.min(x1, x2) - radius;
        this.minY = Math.min(y1, y2) - radius;
        this.maxX = Math.max(x1, x2) + radius;
        this.maxY = Math.max(y1, y2) + radius;
    }

    public int x1() {
        return this.x1;
    }

    public int y1() {
        return this.y1;
    }

    public int x2() {
        return this.x2;
    }

    public int y2() {
        return this.y2;
    }

    public boolean overlaps(RiverBounds other) {
        if (this.minX > other.maxX || this.maxX < other.minX) {
            return false;
        }
        return this.minY <= other.maxY && this.maxY >= other.minY;
    }

    public Vec2f pos(float distance) {
        int dx = this.x2() - this.x1();
        int dy = this.y2() - this.y1();
        return new Vec2f((float)this.x1() + (float)dx * distance, (float)this.y1() + (float)dy * distance);
    }

    public static RiverBounds fromNodes(RiverNode p1, RiverNode p2) {
        if (p1.type == RiverNode.Type.START) {
            return new RiverBounds(p1.x, p1.z, p2.x, p2.z, 300);
        }
        return new RiverBounds(p2.x, p2.z, p1.x, p1.z, 300);
    }
}

