/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Name;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;
import me.dags.noise.Module;
import me.dags.noise.Source;

@Serializable
public class GeneratorSettings {
    public transient long seed = 0L;
    public World world = new World();
    public Land land = new Land();
    public Biome biome = new Biome();
    public BiomeNoise biomeEdgeNoise = new BiomeNoise();

    @Serializable
    public static class BiomeNoise {
        @Comment(value={"The noise type"})
        public Source type = Source.PERLIN;
        @Range(min=1.0f, max=500.0f)
        @Comment(value={"Controls the scale of the noise"})
        public int scale = 8;
        @Range(min=1.0f, max=5.0f)
        @Comment(value={"Controls the number of noise octaves"})
        public int octaves = 2;
        @Range(min=0.0f, max=5.5f)
        @Comment(value={"Controls the gain subsequent noise octaves"})
        public float gain = 0.5f;
        @Range(min=0.0f, max=10.5f)
        @Comment(value={"Controls the lacunarity of subsequent noise octaves"})
        public float lacunarity = 2.5f;
        @Range(min=1.0f, max=500.0f)
        @Comment(value={"Controls the strength of the noise"})
        public int strength = 24;

        public Module build(int seed) {
            return Source.build(seed, this.scale, this.octaves).gain(this.gain).lacunarity(this.lacunarity).build(this.type).bias(-0.5);
        }
    }

    @Serializable
    public static class Biome {
        @Range(min=50.0f, max=1000.0f)
        @Comment(value={"Controls the size of individual biomes"})
        public int biomeSize = 200;
        @Range(min=1.0f, max=500.0f)
        @Comment(value={"Controls the scale of shape distortion for biomes"})
        public int biomeWarpScale = 35;
        @Range(min=1.0f, max=500.0f)
        @Comment(value={"Controls the strength of shape distortion for biomes"})
        public int biomeWarpStrength = 70;
    }

    @Serializable
    public static class Land {
        @Range(min=100.0f, max=10000.0f)
        @Comment(value={"Controls the size of continents"})
        public int continentScale = 4000;
        @Range(min=250.0f, max=5000.0f)
        @Name(value="Mountain Range Scale")
        @Comment(value={"Controls the size of mountain ranges"})
        public int mountainScale = 950;
        @Range(min=125.0f, max=5000.0f)
        @Comment(value={"Controls the size of terrain regions"})
        public int regionSize = 1000;
    }

    @Serializable
    public static class World {
        @Range(min=0.0f, max=256.0f)
        @Comment(value={"Controls the world height"})
        public int worldHeight = 256;
        @Range(min=0.0f, max=255.0f)
        @Comment(value={"Controls the sea level"})
        public int seaLevel = 63;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls the amount of ocean between continents"})
        public float oceanSize = 0.25f;
    }
}

