/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.nbt;

import com.davenonymous.libnonymous.utils.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.utils.Logz;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public class NBTFieldHandlers {
    private static final Map<Class<?>, Pair<NbtReader, NbtWriter>> nbtHandlers = new HashMap();

    public static <T> void addNBTHandler(Class<T> type, NbtReader<T> reader, NbtWriter<T> writer) {
        nbtHandlers.put(type, (Pair<NbtReader, NbtWriter>)Pair.of(reader, writer));
    }

    public static boolean hasNBTHandler(Class clz) {
        if (nbtHandlers.containsKey(clz)) {
            return true;
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!nbtHandlers.containsKey(iface)) continue;
            return true;
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return NBTFieldHandlers.hasNBTHandler(superClass);
    }

    public static Pair<NbtReader, NbtWriter> getNBTHandler(Class clz) {
        if (nbtHandlers.containsKey(clz)) {
            return nbtHandlers.get(clz);
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!nbtHandlers.containsKey(iface)) continue;
            return nbtHandlers.get(iface);
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return NBTFieldHandlers.getNBTHandler(superClass);
    }

    static {
        NBTFieldHandlers.addNBTHandler(boolean[].class, (key, tag) -> {
            ListNBT listNBT = tag.func_150295_c(key, 2);
            boolean[] result = new boolean[listNBT.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = listNBT.func_202170_f(i) == 1;
            }
            return null;
        }, (key, booleans, tag) -> {
            ListNBT listNBT = new ListNBT();
            for (boolean b : booleans) {
                listNBT.add((Object)ShortNBT.func_229701_a_((short)(b ? (short)1 : (short)0)));
            }
            tag.func_218657_a(key, (INBT)listNBT);
        });
        NBTFieldHandlers.addNBTHandler(Boolean.TYPE, (key, tag) -> tag.func_74767_n(key), (key, aBoolean, tag) -> tag.func_74757_a(key, aBoolean.booleanValue()));
        NBTFieldHandlers.addNBTHandler(Boolean.class, (key, tag) -> tag.func_74767_n(key), (key, aBoolean, tag) -> tag.func_74757_a(key, aBoolean.booleanValue()));
        NBTFieldHandlers.addNBTHandler(Integer.TYPE, (key, tag) -> tag.func_74762_e(key), (key, val, tag) -> tag.func_74768_a(key, val.intValue()));
        NBTFieldHandlers.addNBTHandler(Integer.class, (key, tag) -> tag.func_74762_e(key), (key, integer, tag) -> tag.func_74768_a(key, integer.intValue()));
        NBTFieldHandlers.addNBTHandler(Float.TYPE, (key, tag) -> Float.valueOf(tag.func_74760_g(key)), (key, val, tag) -> tag.func_74776_a(key, val.floatValue()));
        NBTFieldHandlers.addNBTHandler(Float.class, (key, tag) -> Float.valueOf(tag.func_74760_g(key)), (key, val, tag) -> tag.func_74776_a(key, val.floatValue()));
        NBTFieldHandlers.addNBTHandler(Double.TYPE, (key, tag) -> tag.func_74769_h(key), (key, val, tag) -> tag.func_74780_a(key, val.doubleValue()));
        NBTFieldHandlers.addNBTHandler(Double.class, (key, tag) -> tag.func_74769_h(key), (key, val, tag) -> tag.func_74780_a(key, val.doubleValue()));
        NBTFieldHandlers.addNBTHandler(Long.TYPE, (key, tag) -> tag.func_74763_f(key), (key, val, tag) -> tag.func_74772_a(key, val.longValue()));
        NBTFieldHandlers.addNBTHandler(Long.class, (key, tag) -> tag.func_74763_f(key), (key, val, tag) -> tag.func_74772_a(key, val.longValue()));
        NBTFieldHandlers.addNBTHandler(String.class, (key, tag) -> tag.func_74764_b(key) ? tag.func_74779_i(key) : null, (key, s, tag) -> {
            if (s != null) {
                tag.func_74778_a(key, s);
            }
        });
        NBTFieldHandlers.addNBTHandler(ItemStack.class, (key, tag) -> ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(key)), (key, itemStack, tag) -> tag.func_218657_a(key, (INBT)itemStack.serializeNBT()));
        NBTFieldHandlers.addNBTHandler(Enum.class, (key, tag) -> {
            CompoundNBT enumTag = tag.func_74775_l(key);
            try {
                Class<?> clz = Class.forName(enumTag.func_74779_i("class"));
                return Enum.valueOf(clz, enumTag.func_74779_i("value"));
            }
            catch (ClassNotFoundException e) {
                Logz.warn("Could not find enum '{}' during NBT deserialization", tag.func_74779_i(key));
                e.printStackTrace();
                return null;
            }
        }, (key, anEnum, tag) -> {
            CompoundNBT result = new CompoundNBT();
            result.func_74778_a("class", anEnum.getClass().getName());
            result.func_74778_a("value", anEnum.name());
            tag.func_218657_a(key, (INBT)result);
        });
        NBTFieldHandlers.addNBTHandler(Class.class, (key, tag) -> {
            if (key.equals("") || !tag.func_74764_b(key)) {
                return null;
            }
            try {
                return Class.forName(tag.func_74779_i(key));
            }
            catch (ClassNotFoundException e) {
                Logz.warn("Could not find class '{}' during NBT deserialization", tag.func_74779_i(key));
                e.printStackTrace();
                return null;
            }
        }, (key, aClass, tag) -> {
            if (aClass != null) {
                tag.func_74778_a(key, aClass.getName());
            }
        });
        NBTFieldHandlers.addNBTHandler(ResourceLocation.class, (key, tag) -> {
            if (!tag.func_74764_b(key)) {
                return null;
            }
            return new ResourceLocation(tag.func_74779_i(key));
        }, (key, resourceLocation, tag) -> {
            if (resourceLocation == null) {
                return;
            }
            tag.func_74778_a(key, resourceLocation.toString());
        });
        NBTFieldHandlers.addNBTHandler(BlockPos.class, (key, tag) -> {
            CompoundNBT container = tag.func_74775_l(key);
            return new BlockPos(container.func_74762_e("x"), container.func_74762_e("y"), container.func_74762_e("z"));
        }, (key, pos, tag) -> {
            CompoundNBT container = new CompoundNBT();
            container.func_74768_a("x", pos.func_177958_n());
            container.func_74768_a("y", pos.func_177956_o());
            container.func_74768_a("z", pos.func_177952_p());
            tag.func_218657_a(key, (INBT)container);
        });
        NBTFieldHandlers.addNBTHandler(BlockState.class, (key, tag) -> BlockStateSerializationHelper.deserializeBlockState(tag.func_74775_l(key)), (key, blockState, tag) -> tag.func_218657_a(key, (INBT)BlockStateSerializationHelper.serializeBlockStateToNBT(blockState)));
        NBTFieldHandlers.addNBTHandler(UUID.class, (key, tag) -> {
            if (!tag.func_74764_b(key)) {
                return null;
            }
            CompoundNBT containerTag = tag.func_74775_l(key);
            return containerTag.func_186857_a("");
        }, (key, uuid, tag) -> {
            if (uuid == null) {
                return;
            }
            CompoundNBT containerTag = new CompoundNBT();
            containerTag.func_186854_a("", uuid);
            tag.func_218657_a(key, (INBT)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(INBTSerializable.class, (key, tag) -> {
            CompoundNBT containerTag = tag.func_74775_l(key);
            String className = containerTag.func_74779_i("class");
            try {
                Class<?> clz = Class.forName(className);
                INBTSerializable obj = (INBTSerializable)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                obj.deserializeNBT((INBT)containerTag.func_74775_l("data"));
                return obj;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }, (key, INBTSerializable2, tag) -> {
            CompoundNBT containerTag = new CompoundNBT();
            containerTag.func_74778_a("class", INBTSerializable2.getClass().getName());
            containerTag.func_218657_a("data", INBTSerializable2.serializeNBT());
            tag.func_218657_a(key, (INBT)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(Map.class, (key, tag) -> {
            CompoundNBT containerTag = tag.func_74775_l(key);
            if (!containerTag.func_74764_b("isEmpty") || containerTag.func_74767_n("isEmpty") || !containerTag.func_74764_b("entries")) {
                return new HashMap();
            }
            HashMap result = new HashMap();
            try {
                Class<?> keyClass = Class.forName(containerTag.func_74779_i("keyClass"));
                if (!NBTFieldHandlers.hasNBTHandler(keyClass)) {
                    Logz.warn("No NBT deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return new HashMap();
                }
                Class<?> valueClass = Class.forName(containerTag.func_74779_i("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT deserialization methods for values in map (type='{}') exists.", valueClass);
                    return new HashMap();
                }
                NbtReader keyReader = (NbtReader)NBTFieldHandlers.getNBTHandler(keyClass).getLeft();
                NbtReader valueReader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (INBT baseTag : containerTag.func_150295_c("entries", 10)) {
                    CompoundNBT entry = (CompoundNBT)baseTag;
                    Object keyObject = keyReader.read("key", entry);
                    Object valueObject = valueReader.read("value", entry);
                    result.put(keyObject, valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, map, tag) -> {
            CompoundNBT containerTag = new CompoundNBT();
            containerTag.func_74757_a("isEmpty", map.isEmpty());
            if (!map.isEmpty()) {
                Class<?> keyClass = map.keySet().toArray()[0].getClass();
                if (!NBTFieldHandlers.hasNBTHandler(keyClass)) {
                    Logz.warn("No NBT deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return;
                }
                Class<?> valueClass = map.values().toArray()[0].getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT deserialization methods for values in map (type='{}') exists.", valueClass);
                    return;
                }
                containerTag.func_74778_a("keyClass", keyClass.getName());
                containerTag.func_74778_a("valueClass", valueClass.getName());
                NbtWriter keyWriter = (NbtWriter)NBTFieldHandlers.getNBTHandler(keyClass).getRight();
                NbtWriter valueWriter = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListNBT data = new ListNBT();
                for (Map.Entry e : map.entrySet()) {
                    CompoundNBT entryTag = new CompoundNBT();
                    Map.Entry entry = e;
                    keyWriter.write("key", entry.getKey(), entryTag);
                    valueWriter.write("value", entry.getValue(), entryTag);
                    data.add((Object)entryTag);
                }
                containerTag.func_218657_a("entries", (INBT)data);
            }
            tag.func_218657_a(key, (INBT)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(List.class, (key, tag) -> {
            ArrayList result = new ArrayList();
            CompoundNBT containerTag = tag.func_74775_l(key);
            if (!containerTag.func_74764_b("isEmpty") || containerTag.func_74767_n("isEmpty") || !containerTag.func_74764_b("values")) {
                return result;
            }
            try {
                Class<?> valueClass = Class.forName(containerTag.func_74779_i("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT deserialization methods for values in list (type='{}') exists.", valueClass);
                    return result;
                }
                NbtReader reader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (INBT baseTag : containerTag.func_150295_c("values", 10)) {
                    CompoundNBT entry = (CompoundNBT)baseTag;
                    Object value = reader.read("data", entry);
                    result.add(value);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, list, tag) -> {
            CompoundNBT containerTag = new CompoundNBT();
            containerTag.func_74757_a("isEmpty", list.isEmpty());
            if (!list.isEmpty()) {
                Class<?> valueClass = list.get(0).getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT serialization methods for values in list (type='{}') exists.", valueClass.getName());
                    return;
                }
                containerTag.func_74778_a("valueClass", valueClass.getName());
                NbtWriter writer = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListNBT data = new ListNBT();
                for (Object e : list) {
                    CompoundNBT entryContainerTag = new CompoundNBT();
                    writer.write("data", e, entryContainerTag);
                    data.add((Object)entryContainerTag);
                }
                containerTag.func_218657_a("values", (INBT)data);
            }
            tag.func_218657_a(key, (INBT)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(Queue.class, (key, tag) -> {
            CompoundNBT containerTag = tag.func_74775_l(key);
            if (!containerTag.func_74764_b("isEmpty") || containerTag.func_74767_n("isEmpty") || !containerTag.func_74764_b("values")) {
                return new ArrayDeque();
            }
            ArrayDeque result = new ArrayDeque();
            try {
                Class<?> valueClass = Class.forName(containerTag.func_74779_i("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT deserialization methods for values in queue (type='{}') exists.", valueClass);
                    return new ArrayDeque();
                }
                NbtReader reader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (INBT baseTag : containerTag.func_150295_c("values", 10)) {
                    CompoundNBT entry = (CompoundNBT)baseTag;
                    Object value = reader.read("data", entry);
                    result.add(value);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, queue, tag) -> {
            CompoundNBT containerTag = new CompoundNBT();
            containerTag.func_74757_a("isEmpty", queue.isEmpty());
            if (!queue.isEmpty()) {
                Class<?> valueClass = queue.peek().getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    Logz.warn("No NBT serialization methods for values in list (type='{}') exists.", valueClass.getName());
                    return;
                }
                containerTag.func_74778_a("valueClass", valueClass.getName());
                NbtWriter writer = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListNBT data = new ListNBT();
                for (Object e : queue) {
                    CompoundNBT entryContainerTag = new CompoundNBT();
                    writer.write("data", e, entryContainerTag);
                    data.add((Object)entryContainerTag);
                }
                containerTag.func_218657_a("values", (INBT)data);
            }
            tag.func_218657_a(key, (INBT)containerTag);
        });
    }

    public static interface NbtReader<T> {
        public T read(String var1, CompoundNBT var2);
    }

    public static interface NbtWriter<T> {
        public void write(String var1, T var2, CompoundNBT var3);
    }
}

