/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment.override;

import cofh.lib.enchantment.EnchantmentOverride;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class ProtectionEnchantmentImp
extends EnchantmentOverride {
    private Type protectionType;

    public ProtectionEnchantmentImp(Enchantment.Rarity rarityIn, Type protectionTypeIn, EquipmentSlotType[] slots) {
        super(rarityIn, EnchantmentType.ARMOR, slots);
        this.protectionType = protectionTypeIn;
        if (protectionTypeIn == Type.FALL) {
            this.field_77351_y = EnchantmentType.ARMOR_FEET;
        }
        this.maxLevel = 4;
    }

    public int func_77318_a(int level, DamageSource source) {
        if (level <= 0 || source.func_76357_e()) {
            return 0;
        }
        if (this.protectionType == Type.ALL) {
            return level;
        }
        if (this.protectionType == Type.FALL && source == DamageSource.field_76379_h) {
            return level * 3;
        }
        if (this.protectionType == Type.FIRE && source.func_76347_k()) {
            return level * 2;
        }
        if (this.protectionType == Type.EXPLOSION && source.func_94541_c()) {
            return level * 2;
        }
        if (this.protectionType == Type.MAGIC && source.func_82725_o()) {
            return level * 2;
        }
        return this.protectionType == Type.PROJECTILE && source.func_76352_a() ? level * 2 : 0;
    }

    public int func_77321_a(int level) {
        return this.protectionType.getMinimalEnchantability() + (level - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + this.protectionType.getEnchantIncreasePerLevel();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!this.enable) {
            return super.canApplyAtEnchantingTable(stack);
        }
        Item item = stack.func_77973_b();
        return this.enable && (this.field_77351_y != null && this.field_77351_y.func_77557_a(item) || item instanceof HorseArmorItem || this.supportsEnchantment(stack));
    }

    public boolean func_77326_a(Enchantment ench) {
        if (ench instanceof ProtectionEnchantmentImp) {
            ProtectionEnchantmentImp enchProtection = (ProtectionEnchantmentImp)ench;
            if (this.protectionType == enchProtection.protectionType) {
                return false;
            }
            return this.protectionType == Type.FALL || enchProtection.protectionType == Type.FALL;
        }
        return super.func_77326_a(ench);
    }

    public boolean isAllowedOnBooks() {
        return this.protectionType == Type.MAGIC ? this.enable && this.allowOnBooks : this.allowOnBooks;
    }

    public static enum Type {
        ALL("all", 1, 11),
        FALL("fall", 5, 6),
        FIRE("fire", 10, 8),
        EXPLOSION("explosion", 5, 8),
        MAGIC("magic", 10, 8),
        PROJECTILE("projectile", 3, 6);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;

        private Type(String typeName, int minEnchantability, int levelCost) {
            this.typeName = typeName;
            this.minEnchantability = minEnchantability;
            this.levelCost = levelCost;
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }
    }
}

