/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.proxy.ProxyGasHandler;
import mekanism.common.capabilities.resolver.advanced.AdvancedCapabilityResolver;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityPressurizedTube
extends TileEntityTransmitter<IGasHandler, GasNetwork, GasStack>
implements IMekanismGasHandler {
    public final TubeTier tier;
    @Nonnull
    public GasStack lastWrite = GasStack.EMPTY;
    private final List<IGasTank> tanks;
    public BasicGasTank buffer;

    public TileEntityPressurizedTube(IBlockProvider blockProvider) {
        super(blockProvider);
        this.tier = Attribute.getTier(blockProvider.getBlock(), TubeTier.class);
        this.buffer = BasicGasTank.create(this.getCapacity(), BasicGasTank.alwaysFalse, BasicGasTank.alwaysTrue, BasicGasTank.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, (IMekanismGasHandler)this);
        this.tanks = Collections.singletonList(this.buffer);
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.GAS_HANDLER_CAPABILITY, this, () -> new ProxyGasHandler(this, null, null)));
    }

    @Override
    public void func_73660_a() {
        Set<Direction> connections;
        if (!this.isRemote() && !(connections = this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)).isEmpty()) {
            for (IGasHandler connectedAcceptor : GasUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w(), connections)) {
                GasStack bufferWithFallback;
                GasStack received;
                if (connectedAcceptor == null || (received = (bufferWithFallback = this.getBufferWithFallback()).isEmpty() ? connectedAcceptor.extractGas(this.getAvailablePull(), Action.SIMULATE) : connectedAcceptor.extractGas(new GasStack(bufferWithFallback, this.getAvailablePull()), Action.SIMULATE)).isEmpty() || !this.takeGas(received, Action.SIMULATE).isEmpty()) continue;
                GasStack remainder = this.takeGas(received, Action.EXECUTE);
                connectedAcceptor.extractGas(new GasStack(received, received.getAmount() - remainder.getAmount()), Action.EXECUTE);
            }
        }
        super.func_73660_a();
    }

    private long getAvailablePull() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return Math.min(this.tier.getTubePullAmount(), ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).gasTank.getNeeded());
        }
        return Math.min(this.tier.getTubePullAmount(), this.buffer.getNeeded());
    }

    @Override
    @Nonnull
    public GasStack insertGas(int tank, @Nonnull GasStack stack, @Nullable Direction side, @Nonnull Action action) {
        IGasTank gasTank = this.getGasTank(tank, side);
        if (gasTank == null) {
            return stack;
        }
        if (side == null) {
            return gasTank.insert(stack, action, AutomationType.INTERNAL);
        }
        TileEntitySidedPipe.ConnectionType connectionType = this.getConnectionType(side);
        if (connectionType == TileEntitySidedPipe.ConnectionType.NORMAL || connectionType == TileEntitySidedPipe.ConnectionType.PULL) {
            return gasTank.insert(stack, action, AutomationType.EXTERNAL);
        }
        return stack;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.lastWrite = nbtTags.func_150297_b("gas", 10) ? GasStack.readFromNBT(nbtTags.func_74775_l("gas")) : GasStack.EMPTY;
        this.buffer.setStack(this.lastWrite);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lastWrite.isEmpty()) {
            nbtTags.func_82580_o("gas");
        } else {
            nbtTags.func_218657_a("gas", (INBT)this.lastWrite.write(new CompoundNBT()));
        }
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.GAS)).isPresent()) {
            return false;
        }
        return this.isAcceptorAndListen(tile, side, Capabilities.GAS_HANDLER_CAPABILITY);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tile) {
        TileEntityPressurizedTube other;
        Gas otherBuffer;
        if (!super.isValidTransmitter(tile)) {
            return false;
        }
        if (!(tile instanceof TileEntityPressurizedTube)) {
            return true;
        }
        Gas buffer = (Gas)this.getBufferWithFallback().getType();
        if (buffer.isEmptyType() && this.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).getPrevTransferAmount() > 0L) {
            buffer = ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).lastGas;
        }
        if ((otherBuffer = (Gas)(other = (TileEntityPressurizedTube)tile).getBufferWithFallback().getType()).isEmptyType() && other.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)other.getTransmitter().getTransmitterNetwork()).getPrevTransferAmount() > 0L) {
            otherBuffer = ((GasNetwork)other.getTransmitter().getTransmitterNetwork()).lastGas;
        }
        return buffer.isEmptyType() || otherBuffer.isEmptyType() || buffer == otherBuffer;
    }

    @Override
    public GasNetwork createNewNetwork() {
        return new GasNetwork();
    }

    @Override
    public GasNetwork createNewNetworkWithID(UUID networkID) {
        return new GasNetwork(networkID);
    }

    @Override
    public GasNetwork createNetworkByMerging(Collection<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getTubeCapacity();
    }

    @Override
    @Nonnull
    public GasStack getBuffer() {
        return (GasStack)this.buffer.getStack();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @Nonnull
    public GasStack getBufferWithFallback() {
        GasStack buffer = this.getBuffer();
        if (buffer.isEmpty() && this.getTransmitter().hasTransmitterNetwork()) {
            return ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            GasNetwork transmitterNetwork = (GasNetwork)this.getTransmitter().getTransmitterNetwork();
            if (!transmitterNetwork.gasTank.isEmpty() && !this.lastWrite.isEmpty()) {
                long amount = this.lastWrite.getAmount();
                MekanismUtils.logMismatchedStackSize(transmitterNetwork.gasTank.shrinkStack(amount, Action.EXECUTE), amount);
                this.buffer.setStack(this.lastWrite);
            }
        }
    }

    @Nonnull
    private GasStack takeGas(GasStack gasStack, Action action) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).gasTank.insert(gasStack, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(gasStack, action, AutomationType.INTERNAL);
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).getGasTanks(side);
        }
        return this.tanks;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty(false);
    }

    @Override
    public IGasHandler getCachedAcceptor(Direction side) {
        return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)this.getCachedTile(side), Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
    }

    @Override
    protected boolean canUpgrade(AlloyTier alloyTier) {
        return alloyTier.getBaseTier().ordinal() == this.tier.getBaseTier().ordinal() + 1;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nullable
    protected PressurizedTubeUpgradeData getUpgradeData() {
        return new PressurizedTubeUpgradeData(this.redstoneReactive, this.connectionTypes, this.getBuffer());
    }

    @Override
    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        if (upgradeData instanceof PressurizedTubeUpgradeData) {
            PressurizedTubeUpgradeData data = (PressurizedTubeUpgradeData)upgradeData;
            this.redstoneReactive = data.redstoneReactive;
            this.connectionTypes = data.connectionTypes;
            this.takeGas(data.contents, Action.EXECUTE);
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        TransmitterImpl transmitter = this.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            updateTag.func_218657_a("gas", (INBT)((GasNetwork)transmitter.getTransmitterNetwork()).lastGas.write(new CompoundNBT()));
            updateTag.func_74776_a("scale", ((GasNetwork)transmitter.getTransmitterNetwork()).gasScale);
        }
        return updateTag;
    }

    @Override
    protected void handleContentsUpdateTag(@Nonnull GasNetwork network, @Nonnull CompoundNBT tag) {
        NBTUtils.setGasIfPresent(tag, "gas", network::setLastGas);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.gasScale = scale;
        });
    }
}

