/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;

public enum DataType implements IIncrementalEnum<DataType>,
IHasTranslationKey
{
    NONE(MekanismLang.SIDE_DATA_NONE, EnumColor.GRAY),
    INPUT(MekanismLang.SIDE_DATA_INPUT, EnumColor.DARK_RED),
    OUTPUT(MekanismLang.SIDE_DATA_OUTPUT, EnumColor.DARK_BLUE),
    ENERGY(MekanismLang.SIDE_DATA_ENERGY, EnumColor.DARK_GREEN),
    EXTRA(MekanismLang.SIDE_DATA_EXTRA, EnumColor.PURPLE);

    private static final DataType[] TYPES;
    private final EnumColor color;
    private final ILangEntry langEntry;

    private DataType(ILangEntry langEntry, EnumColor color) {
        this.color = color;
        this.langEntry = langEntry;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @Override
    @Nonnull
    public DataType byIndex(int index) {
        return DataType.byIndexStatic(index);
    }

    public static DataType byIndexStatic(int index) {
        return MathUtils.getByIndexMod(TYPES, index);
    }

    static {
        TYPES = DataType.values();
    }
}

