/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityElectricPump
extends TileEntityMekanism
implements IConfigurable {
    public BasicFluidTank fluidTank;
    @Nonnull
    private FluidStack activeType = FluidStack.EMPTY;
    private boolean suckedLastOperation;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    private Set<BlockPos> recurringNodes = new ObjectOpenHashSet();
    private MachineEnergyContainer<TileEntityElectricPump> energyContainer;
    private FluidInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityElectricPump() {
        super(MekanismBlocks.ELECTRIC_PUMP);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.output(10000, this);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.drain(this.fluidTank, this, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(this, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectricPump)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.drainTank(this.outputSlot);
        boolean sucked = false;
        if (MekanismUtils.canFunction(this) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (this.suckedLastOperation) {
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.fluidTank.isEmpty() || 1000 <= this.fluidTank.getNeeded()) {
                    if (this.suck()) {
                        sucked = true;
                    } else {
                        this.reset();
                    }
                }
            }
        }
        this.suckedLastOperation = sucked;
        if (!this.fluidTank.isEmpty()) {
            PipeUtils.emit(EnumSet.of(Direction.UP), this.fluidTank, this, 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED)));
        }
    }

    public boolean hasFilter() {
        return this.upgradeComponent.isUpgradeInstalled(Upgrade.FILTER);
    }

    private boolean suck() {
        boolean hasFilter = this.hasFilter();
        for (Direction orientation : EnumUtils.DIRECTIONS) {
            if (!this.suck(this.field_174879_c.func_177972_a(orientation), hasFilter, true)) continue;
            return true;
        }
        List<BlockPos> tempPumpList = Arrays.asList(this.recurringNodes.toArray(new BlockPos[0]));
        Collections.shuffle(tempPumpList);
        for (BlockPos tempPumpPos : tempPumpList) {
            if (this.suck(tempPumpPos, hasFilter, false)) {
                return true;
            }
            for (Direction orientation : EnumUtils.DIRECTIONS) {
                BlockPos side = tempPumpPos.func_177972_a(orientation);
                if (!(Math.sqrt(this.field_174879_c.func_177951_i((Vec3i)side)) <= (double)MekanismConfig.general.maxPumpRange.get()) || !this.suck(side, hasFilter, true)) continue;
                return true;
            }
            this.recurringNodes.remove(tempPumpPos);
        }
        return false;
    }

    private boolean suck(BlockPos pos, boolean hasFilter, boolean addRecurring) {
        IFluidState fluidState = this.field_145850_b.func_204610_c(pos);
        if (!fluidState.func_206888_e() && fluidState.func_206889_d()) {
            BlockState blockState;
            Block block;
            Fluid fluid = fluidState.func_206886_c();
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            if (hasFilter && fluid == Fluids.field_204546_a) {
                fluid = MekanismFluids.HEAVY_WATER.getStillFluid();
                fluidStack = MekanismFluids.HEAVY_WATER.getFluidStack(10);
            }
            if ((block = (blockState = this.field_145850_b.func_180495_p(pos)).func_177230_c()) instanceof IFluidBlock) {
                fluidStack = ((IFluidBlock)block).drain(this.field_145850_b, pos, IFluidHandler.FluidAction.SIMULATE);
                if (this.validFluid(fluidStack, true)) {
                    fluidStack = ((IFluidBlock)block).drain(this.field_145850_b, pos, IFluidHandler.FluidAction.EXECUTE);
                    this.suck(fluidStack, pos, addRecurring);
                    return true;
                }
            } else if (block instanceof IBucketPickupHandler && this.validFluid(fluidStack, false)) {
                if (this.shouldTake(fluid)) {
                    fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)this.field_145850_b, pos, blockState);
                    if (hasFilter && fluid == Fluids.field_204546_a) {
                        fluid = MekanismFluids.HEAVY_WATER.getStillFluid();
                        fluidStack = MekanismFluids.HEAVY_WATER.getFluidStack(10);
                    } else {
                        fluidStack = new FluidStack(fluid, 1000);
                    }
                    if (!this.validFluid(fluidStack, false)) {
                        Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.func_206886_c(), (Object)pos, (Object)this.field_145850_b, (Object)fluid);
                        return false;
                    }
                }
                this.suck(fluidStack, pos, addRecurring);
                return true;
            }
        }
        return false;
    }

    private void suck(@Nonnull FluidStack fluidStack, BlockPos pos, boolean addRecurring) {
        this.activeType = new FluidStack(fluidStack, 1);
        if (addRecurring) {
            this.recurringNodes.add(pos);
        }
        this.fluidTank.insert(fluidStack, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private boolean validFluid(@Nonnull FluidStack fluidStack, boolean recheckSize) {
        if (!fluidStack.isEmpty() && (this.activeType.isEmpty() || this.activeType.isFluidEqual(fluidStack))) {
            if (this.fluidTank.isEmpty()) {
                return true;
            }
            if (this.fluidTank.isFluidEqual(fluidStack)) {
                return !recheckSize || fluidStack.getAmount() <= this.fluidTank.getNeeded();
            }
        }
        return false;
    }

    public void reset() {
        this.activeType = FluidStack.EMPTY;
        this.recurringNodes.clear();
    }

    private boolean shouldTake(@Nonnull Fluid fluid) {
        return fluid != Fluids.field_204546_a && fluid != MekanismFluids.HEAVY_WATER.getStillFluid() || MekanismConfig.general.pumpWaterSources.get();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("progress", this.operatingTicks);
        nbtTags.func_74757_a("suckedLastOperation", this.suckedLastOperation);
        if (!this.activeType.isEmpty()) {
            nbtTags.func_218657_a("fluid", (INBT)this.activeType.writeToNBT(new CompoundNBT()));
        }
        ListNBT recurringList = new ListNBT();
        for (BlockPos nodePos : this.recurringNodes) {
            recurringList.add((Object)NBTUtil.func_186859_a((BlockPos)nodePos));
        }
        if (!recurringList.isEmpty()) {
            nbtTags.func_218657_a("recurringNodes", (INBT)recurringList);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("progress");
        this.suckedLastOperation = nbtTags.func_74767_n("suckedLastOperation");
        NBTUtils.setFluidStackIfPresent(nbtTags, "fluid", fluid -> {
            this.activeType = fluid;
        });
        if (nbtTags.func_150297_b("recurringNodes", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("recurringNodes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.recurringNodes.add(NBTUtil.func_186861_c((CompoundNBT)tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        this.reset();
        player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.PUMP_RESET.translateColored(EnumColor.GRAY, new Object[0])));
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public List<ITextComponent> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityElectricPump> getEnergyContainer() {
        return this.energyContainer;
    }
}

