/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.inputs.InfusionIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MetallurgicInfuserRecipeSerializer<T extends MetallurgicInfuserRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public MetallurgicInfuserRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        JsonArray infusionInput = JSONUtils.func_151202_d((JsonObject)json, (String)"infusionInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"infusionInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"infusionInput");
        InfusionIngredient infusionIngredient = InfusionIngredient.deserialize((JsonElement)infusionInput);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        if (output.func_190926_b()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, infusionIngredient, output);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient itemInput = ItemStackIngredient.read(buffer);
            InfusionIngredient infusionInput = InfusionIngredient.read(buffer);
            ItemStack output = buffer.func_150791_c();
            return this.factory.create(recipeId, itemInput, infusionInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading metallurgic infuser recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((MetallurgicInfuserRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing metallurgic infuser recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends MetallurgicInfuserRecipe> {
        public T create(ResourceLocation var1, ItemStackIngredient var2, InfusionIngredient var3, ItemStack var4);
    }
}

