/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyInventorySlot
extends BasicInventorySlot {
    private final Supplier<World> worldSupplier;
    private final IEnergyContainer energyContainer;

    private static FloatingLong getPotentialConversion(@Nullable World world, ItemStack itemStack) {
        ItemStackToEnergyRecipe foundRecipe = MekanismRecipeType.ENERGY_CONVERSION.findFirst(world, recipe -> recipe.getInput().testType(itemStack));
        return foundRecipe == null ? FloatingLong.ZERO : foundRecipe.getOutput(itemStack);
    }

    public static EnergyInventorySlot fillOrConvert(IEnergyContainer energyContainer, Supplier<World> worldSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, FloatingLong> potentialConversionSupplier = stack -> EnergyInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
        return new EnergyInventorySlot(energyContainer, worldSupplier, stack -> !EnergyCompatUtils.hasStrictEnergyHandler(stack) && ((FloatingLong)potentialConversionSupplier.apply((ItemStack)stack)).isZero(), stack -> {
            if (EnergyInventorySlot.fillInsertCheck(stack)) {
                return true;
            }
            FloatingLong conversion = (FloatingLong)potentialConversionSupplier.apply((ItemStack)stack);
            return !conversion.isZero() && energyContainer.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).smallerThan(conversion);
        }, stack -> EnergyCompatUtils.hasStrictEnergyHandler(stack) || !EnergyInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack).isZero(), inventory, x, y);
    }

    public static EnergyInventorySlot fill(IEnergyContainer energyContainer, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        return new EnergyInventorySlot(energyContainer, stack -> !EnergyCompatUtils.hasStrictEnergyHandler(stack), EnergyInventorySlot::fillInsertCheck, EnergyCompatUtils::hasStrictEnergyHandler, inventory, x, y);
    }

    public static EnergyInventorySlot drain(IEnergyContainer energyContainer, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(energyContainer, "Energy container cannot be null");
        Predicate<@NonNull ItemStack> insertPredicate = stack -> {
            IStrictEnergyHandler itemHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
            if (itemHandler == null) {
                return false;
            }
            if (energyContainer.isEmpty()) {
                for (int container = 0; container < itemHandler.getEnergyContainerCount(); ++container) {
                    if (itemHandler.getNeededEnergy(container).isZero()) continue;
                    return true;
                }
                return false;
            }
            return itemHandler.insertEnergy(energyContainer.getEnergy(), Action.SIMULATE).smallerThan(energyContainer.getEnergy());
        };
        return new EnergyInventorySlot(energyContainer, insertPredicate.negate(), insertPredicate, EnergyCompatUtils::hasStrictEnergyHandler, inventory, x, y);
    }

    private static boolean fillInsertCheck(ItemStack stack) {
        IStrictEnergyHandler itemHandler = EnergyCompatUtils.getStrictEnergyHandler(stack);
        if (itemHandler != null) {
            for (int container = 0; container < itemHandler.getEnergyContainerCount(); ++container) {
                FloatingLong energyInContainer = itemHandler.getEnergy(container);
                if (energyInContainer.isZero()) continue;
                return true;
            }
        }
        return false;
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        this(energyContainer, () -> null, canExtract, canInsert, validator, inventory, x, y);
    }

    private EnergyInventorySlot(IEnergyContainer energyContainer, Supplier<World> worldSupplier, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super(canExtract, canInsert, validator, inventory, x, y);
        this.energyContainer = energyContainer;
        this.worldSupplier = worldSupplier;
        this.setSlotType(ContainerSlotType.POWER);
        this.setSlotOverlay(SlotOverlay.POWER);
    }

    public void fillContainerOrConvert() {
        FloatingLong output;
        ItemStack itemInput;
        ItemStackToEnergyRecipe foundRecipe;
        if (!(this.isEmpty() || this.energyContainer.getNeeded().isZero() || this.fillContainerFromItem() || (foundRecipe = MekanismRecipeType.ENERGY_CONVERSION.findFirst(this.worldSupplier.get(), recipe -> recipe.getInput().test(this.current))) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).func_190926_b() || (output = foundRecipe.getOutput(itemInput)).isZero() || !this.energyContainer.insert(output, Action.SIMULATE, AutomationType.MANUAL).isZero())) {
            MekanismUtils.logExpectedZero(this.energyContainer.insert(output, Action.EXECUTE, AutomationType.MANUAL));
            int amountUsed = itemInput.func_190916_E();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillContainer() {
        if (!this.isEmpty() && !this.energyContainer.getNeeded().isZero()) {
            this.fillContainerFromItem();
        }
    }

    private boolean fillContainerFromItem() {
        IStrictEnergyHandler itemHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current);
        if (itemHandler != null) {
            boolean didTransfer = false;
            for (int container = 0; container < itemHandler.getEnergyContainerCount(); ++container) {
                FloatingLong extractedEnergy;
                FloatingLong simulatedRemainder;
                FloatingLong energyInItem = itemHandler.getEnergy(container);
                if (energyInItem.isZero() || !(simulatedRemainder = this.energyContainer.insert(energyInItem, Action.SIMULATE, AutomationType.INTERNAL)).smallerThan(energyInItem) || (extractedEnergy = itemHandler.extractEnergy(container, energyInItem.subtract(simulatedRemainder), Action.EXECUTE)).isZero()) continue;
                MekanismUtils.logExpectedZero(this.energyContainer.insert(extractedEnergy, Action.EXECUTE, AutomationType.INTERNAL));
                didTransfer = true;
                if (this.energyContainer.getNeeded().isZero()) break;
            }
            if (didTransfer) {
                this.onContentsChanged();
                return true;
            }
        }
        return false;
    }

    public void drainContainer() {
        FloatingLong extractedEnergy;
        FloatingLong storedEnergy;
        FloatingLong simulatedRemainder;
        IStrictEnergyHandler itemHandler;
        if (!this.isEmpty() && !this.energyContainer.isEmpty() && (itemHandler = EnergyCompatUtils.getStrictEnergyHandler(this.current)) != null && (simulatedRemainder = itemHandler.insertEnergy(storedEnergy = this.energyContainer.getEnergy(), Action.SIMULATE)).smallerThan(storedEnergy) && !(extractedEnergy = this.energyContainer.extract(storedEnergy.subtract(simulatedRemainder), Action.EXECUTE, AutomationType.INTERNAL)).isZero()) {
            MekanismUtils.logExpectedZero(itemHandler.insertEnergy(extractedEnergy, Action.EXECUTE));
            this.onContentsChanged();
        }
    }
}

