/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class Frequency {
    public static final String TELEPORTER = "Teleporter";
    public String name;
    public UUID ownerUUID;
    public String clientOwner;
    public boolean valid = true;
    public boolean publicFreq;
    public Set<Coord4D> activeCoords = new ObjectOpenHashSet();
    private final FrequencyType frequencyType;

    public Frequency(String name, UUID uuid) {
        this(FrequencyType.BASE, name, uuid);
    }

    public Frequency(FrequencyType frequencyType, String name, UUID uuid) {
        this.frequencyType = frequencyType;
        this.name = name;
        this.ownerUUID = uuid;
    }

    public Frequency(CompoundNBT nbtTags, boolean fromUpdate) {
        this(FrequencyType.BASE, nbtTags, fromUpdate);
    }

    public Frequency(FrequencyType frequencyType, CompoundNBT nbtTags, boolean fromUpdate) {
        this.frequencyType = frequencyType;
        if (fromUpdate) {
            this.readFromUpdateTag(nbtTags);
        } else {
            this.read(nbtTags);
        }
    }

    protected Frequency(FrequencyType frequencyType, PacketBuffer dataStream) {
        this.frequencyType = frequencyType;
        this.read(dataStream);
    }

    public FrequencyType getFrequencyType() {
        return this.frequencyType;
    }

    public boolean isPublic() {
        return this.publicFreq;
    }

    public Frequency setPublic(boolean isPublic) {
        this.publicFreq = isPublic;
        return this;
    }

    public boolean isPrivate() {
        return !this.publicFreq;
    }

    public Coord4D getClosestCoords(Coord4D coord) {
        Coord4D closest = null;
        for (Coord4D iterCoord : this.activeCoords) {
            if (iterCoord.equals(coord)) continue;
            if (closest == null) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimension != closest.dimension && coord.dimension == iterCoord.dimension) {
                closest = iterCoord;
                continue;
            }
            if (coord.dimension == closest.dimension && coord.dimension != iterCoord.dimension || !(coord.distanceTo(closest) > coord.distanceTo(iterCoord))) continue;
            closest = iterCoord;
        }
        return closest;
    }

    public void writeToUpdateTag(CompoundNBT updateTag) {
        updateTag.func_74778_a("name", this.name);
        updateTag.func_186854_a("owner", this.ownerUUID);
        updateTag.func_74757_a("publicFreq", this.publicFreq);
    }

    public void write(CompoundNBT nbtTags) {
        this.writeToUpdateTag(nbtTags);
    }

    protected void readFromUpdateTag(CompoundNBT updateTag) {
        this.name = updateTag.func_74779_i("name");
        NBTUtils.setUUIDIfPresent(updateTag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        this.publicFreq = updateTag.func_74767_n("publicFreq");
    }

    protected void read(CompoundNBT nbtTags) {
        this.readFromUpdateTag(nbtTags);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getFrequencyType());
        buffer.func_180714_a(this.name);
        buffer.func_179252_a(this.ownerUUID);
        buffer.func_180714_a(MekanismUtils.getLastKnownUsername(this.ownerUUID));
        buffer.writeBoolean(this.publicFreq);
    }

    protected void read(PacketBuffer dataStream) {
        this.name = BasePacketHandler.readString(dataStream);
        this.ownerUUID = dataStream.func_179253_g();
        this.clientOwner = BasePacketHandler.readString(dataStream);
        this.publicFreq = dataStream.readBoolean();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        code = 31 * code + this.ownerUUID.hashCode();
        code = 31 * code + (this.publicFreq ? 1 : 0);
        return code;
    }

    public boolean equals(Object obj) {
        return obj instanceof Frequency && ((Frequency)obj).name.equals(this.name) && ((Frequency)obj).ownerUUID.equals(this.ownerUUID) && ((Frequency)obj).publicFreq == this.publicFreq;
    }

    public Identity getIdentity() {
        return new Identity(this.name, this.publicFreq);
    }

    public static Frequency readFromPacket(PacketBuffer dataStream) {
        FrequencyType type = (FrequencyType)dataStream.func_179257_a(FrequencyType.class);
        switch (type) {
            case INVENTORY: {
                return new InventoryFrequency(dataStream);
            }
            case SECURITY: {
                return new SecurityFrequency(dataStream);
            }
        }
        return new Frequency(type, dataStream);
    }

    public static class Identity {
        public String name;
        public boolean publicFreq;

        private Identity(String name, boolean publicFreq) {
            this.name = name;
            this.publicFreq = publicFreq;
        }

        @Nullable
        public static Identity load(CompoundNBT data) {
            if (!data.func_74779_i("name").isEmpty()) {
                return new Identity(data.func_74779_i("name"), data.func_74767_n("publicFreq"));
            }
            return null;
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("name", this.name);
            tag.func_74757_a("publicFreq", this.publicFreq);
            return tag;
        }
    }
}

