/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.common.block.BlockBounding;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class TagCache {
    private static final Map<String, List<ItemStack>> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> modIDStacks = new Object2ObjectOpenHashMap();

    public static List<String> getItemTags(ItemStack check) {
        if (check == null) {
            return new ArrayList<String>();
        }
        return check.func_77973_b().getTags().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static List<ItemStack> getItemTagStacks(String oreName) {
        if (itemTagStacks.get(oreName) != null) {
            return itemTagStacks.get(oreName);
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        TagCollection tagCollection = ItemTags.func_199903_a();
        Collection registeredTags = tagCollection.func_199908_a();
        for (Object rl : registeredTags) {
            String string = rl.toString();
            if (oreName.equals(string) || oreName.equals("*")) {
                keys.add(rl);
                continue;
            }
            if (oreName.endsWith("*") && !oreName.startsWith("*")) {
                if (!string.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(rl);
                continue;
            }
            if (oreName.startsWith("*") && !oreName.endsWith("*")) {
                if (!string.endsWith(oreName.substring(1))) continue;
                keys.add(rl);
                continue;
            }
            if (!oreName.startsWith("*") || !oreName.endsWith("*") || !string.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(rl);
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (ResourceLocation resourceLocation : keys) {
            Tag itemTag = tagCollection.func_199910_a(resourceLocation);
            if (itemTag == null) continue;
            for (Item item : itemTag.func_199885_a()) {
                if (items.contains(item)) continue;
                items.add(item);
            }
        }
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        itemTagStacks.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getBlockTagStacks(String oreName) {
        if (blockTagStacks.get(oreName) != null) {
            return blockTagStacks.get(oreName);
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        TagCollection tagCollection = BlockTags.func_199896_a();
        Collection registeredTags = tagCollection.func_199908_a();
        for (Object rl : registeredTags) {
            String string = rl.toString();
            if (oreName.equals(string) || oreName.equals("*")) {
                keys.add(rl);
                continue;
            }
            if (oreName.endsWith("*") && !oreName.startsWith("*")) {
                if (!string.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(rl);
                continue;
            }
            if (oreName.startsWith("*") && !oreName.endsWith("*")) {
                if (!string.endsWith(oreName.substring(1))) continue;
                keys.add(rl);
                continue;
            }
            if (!oreName.startsWith("*") || !oreName.endsWith("*") || !string.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(rl);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ResourceLocation resourceLocation : keys) {
            Tag blockTag = tagCollection.func_199910_a(resourceLocation);
            if (blockTag == null) continue;
            for (Block block : blockTag.func_199885_a()) {
                if (blocks.contains(block)) continue;
                blocks.add(block);
            }
        }
        List<ItemStack> stacks = blocks.stream().map(ItemStack::new).collect(Collectors.toList());
        blockTagStacks.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getModIDStacks(String modName, boolean forceBlock) {
        if (modIDStacks.get(modName) != null) {
            return modIDStacks.get(modName);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (forceBlock && !(item instanceof BlockItem) || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BlockBounding) continue;
            String id = item.getRegistryName().func_110624_b();
            if (modName.equals(id) || modName.equals("*")) {
                stacks.add(new ItemStack((IItemProvider)item));
                continue;
            }
            if (modName.endsWith("*") && !modName.startsWith("*")) {
                if (!id.startsWith(modName.substring(0, modName.length() - 1))) continue;
                stacks.add(new ItemStack((IItemProvider)item));
                continue;
            }
            if (modName.startsWith("*") && !modName.endsWith("*")) {
                if (!id.endsWith(modName.substring(1))) continue;
                stacks.add(new ItemStack((IItemProvider)item));
                continue;
            }
            if (!modName.startsWith("*") || !modName.endsWith("*") || !id.contains(modName.substring(1, modName.length() - 1))) continue;
            stacks.add(new ItemStack((IItemProvider)item));
        }
        modIDStacks.put(modName, stacks);
        return stacks;
    }
}

