/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Coord4D;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

@ParametersAreNonnullByDefault
public class RenderThermalEvaporationController
extends MekanismTileEntityRenderer<TileEntityThermalEvaporationController> {
    public RenderThermalEvaporationController(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityThermalEvaporationController tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.getActive() && tile.height - 2 >= 1 && !tile.inputTank.isEmpty()) {
            FluidRenderData data = new FluidRenderData();
            data.location = new Coord4D(tile.getRenderLocation(), (IWorldReader)tile.func_145831_w());
            data.height = tile.height - 2;
            data.length = 2;
            data.width = 2;
            data.fluidType = tile.inputTank.getFluid();
            matrix.func_227860_a_();
            BlockPos pos = tile.func_174877_v();
            matrix.func_227861_a_((double)(data.location.x - pos.func_177958_n()), (double)(data.location.y - pos.func_177956_o()), (double)(data.location.z - pos.func_177952_p()));
            MekanismRenderer.renderObject(ModelRenderer.getModel(data, Math.min(1.0f, tile.prevScale)), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), data.getColorARGB(tile.prevScale), data.calculateGlowLight(light));
            matrix.func_227865_b_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermalEvaporationController";
    }

    public boolean isGlobalRenderer(TileEntityThermalEvaporationController tile) {
        return tile.getActive() && tile.height - 2 >= 1 && !tile.inputTank.isEmpty();
    }
}

