/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderDynamicTank
extends MekanismTileEntityRenderer<TileEntityDynamicTank> {
    public RenderDynamicTank(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityDynamicTank tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.clientHasStructure && tile.isRendering && tile.structure != null && !((SynchronizedTankData)tile.structure).fluidTank.isEmpty() && ((SynchronizedTankData)tile.structure).renderLocation != null && ((SynchronizedTankData)tile.structure).volHeight > 2) {
            FluidRenderData data = new FluidRenderData();
            data.location = ((SynchronizedTankData)tile.structure).renderLocation;
            data.height = ((SynchronizedTankData)tile.structure).volHeight - 2;
            data.length = ((SynchronizedTankData)tile.structure).volLength;
            data.width = ((SynchronizedTankData)tile.structure).volWidth;
            data.fluidType = ((SynchronizedTankData)tile.structure).fluidTank.getFluid();
            matrix.func_227860_a_();
            IVertexBuilder buffer = renderer.getBuffer(MekanismRenderType.resizableCuboid());
            BlockPos pos = tile.func_174877_v();
            matrix.func_227861_a_((double)(data.location.x - pos.func_177958_n()), (double)(data.location.y - pos.func_177956_o()), (double)(data.location.z - pos.func_177952_p()));
            int glow = data.calculateGlowLight(light);
            MekanismRenderer.Model3D fluidModel = ModelRenderer.getModel(data, tile.prevScale);
            MekanismRenderer.renderObject(fluidModel, matrix, buffer, data.getColorARGB(tile.prevScale), glow);
            matrix.func_227865_b_();
            MekanismRenderer.renderValves(matrix, buffer, ((SynchronizedTankData)tile.structure).valves, data, pos, glow);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "dynamicTank";
    }

    public boolean isGlobalRenderer(TileEntityDynamicTank tile) {
        return tile.clientHasStructure && tile.isRendering && tile.structure != null && !((SynchronizedTankData)tile.structure).fluidTank.isEmpty() && ((SynchronizedTankData)tile.structure).renderLocation != null && ((SynchronizedTankData)tile.structure).volHeight > 2;
    }
}

