/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import mekanism.api.Pos3D;
import mekanism.api.RelativeSide;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.common.ColorRGBA;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.IItemHUDProvider;
import mekanism.common.item.IModeItem;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderTickHandler {
    private static final Map<Direction, Map<TransmissionType, MekanismRenderer.Model3D>> cachedOverlays = new EnumMap<Direction, Map<TransmissionType, MekanismRenderer.Model3D>>(Direction.class);
    private static double HUD_SCALE = 0.6;
    public static int modeSwitchTimer = 0;
    public Random rand = new Random();
    public Minecraft minecraft = Minecraft.func_71410_x();

    public static void resetCachedOverlays() {
        cachedOverlays.clear();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_70170_p != null && !this.minecraft.func_147113_T() && this.minecraft.field_71466_p != null) {
            ItemStack stack;
            ITextComponent scrollTextComponent;
            FontRenderer font = this.minecraft.field_71466_p;
            ClientPlayerEntity player = this.minecraft.field_71439_g;
            World world = this.minecraft.field_71439_g.field_70170_p;
            if (modeSwitchTimer > 1 && this.minecraft.field_71462_r == null && IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND) && (scrollTextComponent = ((IModeItem)(stack = player.func_184614_ca()).func_77973_b()).getScrollTextComponent(stack)) != null) {
                int x = this.minecraft.func_228018_at_().func_198107_o();
                int y = this.minecraft.func_228018_at_().func_198087_p();
                String text = scrollTextComponent.func_150254_d();
                int color = new ColorRGBA(1.0, 1.0, 1.0, (float)modeSwitchTimer / 100.0f).argb();
                font.func_211126_b(text, (float)(x / 2 - font.func_78256_a(text) / 2), (float)(y - 60), color);
            }
            modeSwitchTimer = Math.max(modeSwitchTimer - 1, 0);
            if (this.minecraft.field_71462_r == null && !this.minecraft.field_71474_y.field_74319_N && !player.func_175149_v() && MekanismConfig.client.enableHUD.get()) {
                int y = this.minecraft.func_228018_at_().func_198087_p();
                boolean alignLeft = MekanismConfig.client.alignHUDLeft.get();
                ArrayList<ITextComponent> renderStrings = new ArrayList<ITextComponent>();
                for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
                    ItemStack stack2 = player.func_184582_a(slotType);
                    if (!(stack2.func_77973_b() instanceof IItemHUDProvider)) continue;
                    ((IItemHUDProvider)stack2.func_77973_b()).addHUDStrings(renderStrings, stack2, slotType);
                }
                RenderSystem.pushMatrix();
                RenderSystem.scaled((double)HUD_SCALE, (double)HUD_SCALE, (double)HUD_SCALE);
                int start = 2 + renderStrings.size() * 9;
                for (ITextComponent text : renderStrings) {
                    this.drawString(text, alignLeft, (int)((double)y * (1.0 / HUD_SCALE)) - start, 0xC8C8C8);
                    start -= 9;
                }
                RenderSystem.popMatrix();
            }
            for (UUID uuid : Mekanism.playerState.getActiveJetpacks()) {
                PlayerEntity p = world.func_217371_b(uuid);
                if (p == null) continue;
                Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, 1.7, 0.0);
                float random = (this.rand.nextFloat() - 0.5f) * 0.1f;
                Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).rotatePitch(p.func_225608_bj_() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).rotatePitch(p.func_225608_bj_() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D vCenter = new Pos3D((this.rand.nextFloat() - 0.5f) * 0.4f, -0.86, -0.3).rotatePitch(p.func_225608_bj_() ? 25.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D rLeft = vLeft.scale(random);
                Pos3D rRight = vRight.scale(random);
                Pos3D mLeft = vLeft.scale(0.2).translate(new Pos3D(p.func_213322_ci()));
                Pos3D mRight = vRight.scale(0.2).translate(new Pos3D(p.func_213322_ci()));
                Pos3D mCenter = vCenter.scale(0.2).translate(new Pos3D(p.func_213322_ci()));
                mLeft = mLeft.translate(rLeft);
                mRight = mRight.translate(rRight);
                Pos3D v = playerPos.translate(vLeft).translate(new Pos3D(p.func_213322_ci()));
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mLeft.field_72450_a, mLeft.field_72448_b, mLeft.field_72449_c);
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_SMOKE.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mLeft.field_72450_a, mLeft.field_72448_b, mLeft.field_72449_c);
                v = playerPos.translate(vRight).translate(new Pos3D(p.func_213322_ci()));
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_SMOKE.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);
                v = playerPos.translate(vCenter).translate(new Pos3D(p.func_213322_ci()));
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
                world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_SMOKE.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
            }
            if (world.func_72820_D() % 4L == 0L) {
                for (UUID uuid : Mekanism.playerState.getActiveGasmasks()) {
                    PlayerEntity p = world.func_217371_b(uuid);
                    if (p == null || !p.func_70090_H()) continue;
                    Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, 1.7, 0.0);
                    Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(p.func_70676_i(1.0f))).translate(0.0, -0.2, 0.0);
                    Pos3D motion = vec.scale(0.2).translate(new Pos3D(p.func_213322_ci()));
                    Pos3D v = playerPos.translate(vec);
                    world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.SCUBA_BUBBLE.getParticleType()), v.field_72450_a, v.field_72448_b, v.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.2, motion.field_72449_c);
                }
            }
            if (world.func_72820_D() % 4L == 0L) {
                for (PlayerEntity p : world.func_217369_A()) {
                    Pos3D flameVec;
                    ItemStack currentItem;
                    if (Mekanism.playerState.isFlamethrowerOn(p) || p.field_82175_bq || (currentItem = p.field_71071_by.func_70448_g()).func_190926_b() || !(currentItem.func_77973_b() instanceof ItemFlamethrower) || !GasUtils.hasGas(currentItem)) continue;
                    Pos3D playerPos = new Pos3D((Entity)p);
                    double flameXCoord = 0.0;
                    double flameYCoord = 1.5;
                    double flameZCoord = 0.0;
                    Vec3d motion = p.func_213322_ci();
                    Pos3D flameMotion = new Pos3D(motion.func_82615_a(), p.field_70122_E ? 0.0 : motion.func_82617_b(), motion.func_82616_c());
                    if (player == p && this.minecraft.field_71474_y.field_74320_O == 0) {
                        flameVec = new Pos3D(1.0, 1.0, 1.0).multiply(p.func_70676_i(1.0f)).rotateYaw(5.0f).translate(flameXCoord, flameYCoord + 0.1, flameZCoord);
                    } else {
                        flameXCoord += 0.25;
                        flameXCoord -= (double)0.45f;
                        flameZCoord += (double)0.15f;
                        if (p.func_225608_bj_()) {
                            flameYCoord -= (double)0.55f;
                            flameZCoord -= (double)0.15f;
                        }
                        flameVec = new Pos3D(flameXCoord, flameYCoord -= 0.5, flameZCoord += (double)1.05f).rotateYaw(p.field_70761_aq);
                    }
                    Pos3D mergedVec = playerPos.translate(flameVec);
                    world.func_195594_a((IParticleData)((BasicParticleType)MekanismParticleTypes.JETPACK_FLAME.getParticleType()), mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c, flameMotion.field_72450_a, flameMotion.field_72448_b, flameMotion.field_72449_c);
                }
            }
        }
    }

    @SubscribeEvent
    public void configurableMachine(DrawHighlightEvent.HighlightBlock event) {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        BlockRayTraceResult rayTraceResult = event.getTarget();
        if (!rayTraceResult.func_216346_c().equals((Object)RayTraceResult.Type.MISS)) {
            World world = player.func_130014_f_();
            BlockPos pos = rayTraceResult.func_216350_a();
            IRenderTypeBuffer renderer = event.getBuffers();
            ActiveRenderInfo info = event.getInfo();
            MatrixStack matrix = event.getMatrix();
            IProfiler profiler = world.func_217381_Z();
            BlockState blockState = world.func_180495_p(pos);
            boolean shouldCancel = false;
            profiler.func_76320_a("mekOutline");
            if (!blockState.isAir((IBlockReader)world, pos) && world.func_175723_af().func_177746_a(pos)) {
                TileEntityRenderer tileRenderer;
                TileEntityBoundingBlock tile;
                BlockPos actualPos = pos;
                BlockState actualState = blockState;
                if (blockState.func_177230_c() instanceof BlockBounding && (tile = MekanismUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, pos)) != null) {
                    actualPos = tile.getMainPos();
                    actualState = world.func_180495_p(actualPos);
                }
                if (Attribute.has(actualState.func_177230_c(), Attributes.AttributeCustomSelectionBox.class) && (tile = MekanismUtils.getTileEntity((IBlockReader)world, actualPos)) != null && (tileRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)tile)) instanceof IWireFrameRenderer) {
                    matrix.func_227860_a_();
                    Vec3d viewPosition = info.func_216785_c();
                    matrix.func_227861_a_((double)actualPos.func_177958_n() - viewPosition.field_72450_a, (double)actualPos.func_177956_o() - viewPosition.field_72448_b, (double)actualPos.func_177952_p() - viewPosition.field_72449_c);
                    ((IWireFrameRenderer)tileRenderer).renderWireFrame(tile, event.getPartialTicks(), matrix, renderer.getBuffer(RenderType.func_228659_m_()), 0.0f, 0.0f, 0.0f, 0.4f);
                    matrix.func_227865_b_();
                    shouldCancel = true;
                }
            }
            profiler.func_76319_b();
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (!(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator || !(stack = player.func_184586_b(Hand.OFF_HAND)).func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator)) {
                if (shouldCancel) {
                    event.setCanceled(true);
                }
                return;
            }
            profiler.func_76320_a("configurableMachine");
            ItemConfigurator.ConfiguratorMode state = ((ItemConfigurator)stack.func_77973_b()).getState(stack);
            if (state.isConfigurating()) {
                ISideConfiguration configurable;
                TileComponentConfig config;
                TransmissionType type = Objects.requireNonNull(state.getTransmission(), "Configurating state requires transmission type");
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
                if (tile instanceof ISideConfiguration && (config = (configurable = (ISideConfiguration)tile).getConfig()).supports(type)) {
                    Direction face = rayTraceResult.func_216354_b();
                    DataType dataType = config.getDataType(type, RelativeSide.fromDirections(configurable.getOrientation(), face));
                    if (dataType != null) {
                        Vec3d viewPosition = info.func_216785_c();
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)pos.func_177958_n() - viewPosition.field_72450_a, (double)pos.func_177956_o() - viewPosition.field_72448_b, (double)pos.func_177952_p() - viewPosition.field_72449_c);
                        MekanismRenderer.renderObject(this.getOverlayModel(face, type), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), MekanismRenderer.getColorARGB(dataType.getColor(), 0.6f), 0xF000F0);
                        matrix.func_227865_b_();
                    }
                }
            }
            profiler.func_76319_b();
            if (shouldCancel) {
                event.setCanceled(true);
            }
        }
    }

    private void drawString(ITextComponent textComponent, boolean leftSide, int y, int color) {
        String s = textComponent.func_150254_d();
        FontRenderer font = this.minecraft.field_71466_p;
        if (leftSide) {
            font.func_175063_a(s, 2.0f, (float)y, color);
        } else {
            int width = font.func_78256_a(s) + 2;
            font.func_175063_a(s, (float)(this.minecraft.func_228018_at_().func_198107_o() - width), (float)y, color);
        }
    }

    private MekanismRenderer.Model3D getOverlayModel(Direction side, TransmissionType type) {
        if (cachedOverlays.containsKey(side) && cachedOverlays.get(side).containsKey(type)) {
            return cachedOverlays.get(side).get(type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.setTexture(MekanismRenderer.overlays.get(type));
        if (cachedOverlays.containsKey(side)) {
            cachedOverlays.get(side).put(type, toReturn);
        } else {
            EnumMap<TransmissionType, MekanismRenderer.Model3D> map = new EnumMap<TransmissionType, MekanismRenderer.Model3D>(TransmissionType.class);
            map.put(type, toReturn);
            cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = -0.001;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.001;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = -0.001;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.001;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = -0.001;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.001;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
            }
        }
        return toReturn;
    }
}

