/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.TileEntityDigitalMiner;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public final class MinerVisualRenderer {
    private static final Map<MinerRenderData, MekanismRenderer.Model3D> cachedVisuals = new Object2ObjectOpenHashMap();

    public static void resetCachedVisuals() {
        cachedVisuals.clear();
    }

    public static void render(@Nonnull TileEntityDigitalMiner miner, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer) {
        if (miner.getRadius() <= 64) {
            MekanismRenderer.renderObject(MinerVisualRenderer.getModel(new MinerRenderData(miner)), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), MekanismRenderer.getColorARGB(255, 255, 255, 0.8f), 0xF000F0);
        }
    }

    private static MekanismRenderer.Model3D getModel(MinerRenderData data) {
        if (cachedVisuals.containsKey(data)) {
            return cachedVisuals.get(data);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.whiteIcon);
        model.minX = (double)(-data.radius) + 0.01;
        model.minY = (double)(data.minY - data.yCoord) + 0.01;
        model.minZ = (double)(-data.radius) + 0.01;
        model.maxX = (double)data.radius + 0.99;
        model.maxY = (double)(data.maxY - data.yCoord) - 0.01;
        model.maxZ = (double)data.radius + 0.99;
        return model;
    }

    public static class MinerRenderData {
        public int minY;
        public int maxY;
        public int radius;
        public int yCoord;

        public MinerRenderData(int min, int max, int rad, int y) {
            this.minY = min;
            this.maxY = max;
            this.radius = rad;
            this.yCoord = y;
        }

        public MinerRenderData(TileEntityDigitalMiner miner) {
            this(miner.getMinY(), miner.getMaxY(), miner.getRadius(), miner.func_174877_v().func_177956_o());
        }

        public boolean equals(Object data) {
            return data instanceof MinerRenderData && ((MinerRenderData)data).minY == this.minY && ((MinerRenderData)data).maxY == this.maxY && ((MinerRenderData)data).radius == this.radius && ((MinerRenderData)data).yCoord == this.yCoord;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.minY;
            code = 31 * code + this.maxY;
            code = 31 * code + this.radius;
            code = 31 * code + this.yCoord;
            return code;
        }
    }
}

