/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class GuiGasMode
extends MekanismImageButton {
    private static final ResourceLocation IDLE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_idle.png");
    private static final ResourceLocation EXCESS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_excess.png");
    private static final ResourceLocation DUMP = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_dump.png");
    private final boolean left;
    private final Supplier<TileEntityGasTank.GasMode> gasModeSupplier;

    public GuiGasMode(IGuiWrapper gui, int x, int y, boolean left, Supplier<TileEntityGasTank.GasMode> gasModeSupplier, BlockPos pos, int tank) {
        super(gui, x, y, 10, IDLE, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.GAS_MODE_BUTTON, pos, tank)));
        this.left = left;
        this.gasModeSupplier = gasModeSupplier;
    }

    @Override
    protected ResourceLocation getResource() {
        TileEntityGasTank.GasMode mode = this.gasModeSupplier.get();
        switch (mode) {
            case DUMPING_EXCESS: {
                return EXCESS;
            }
            case DUMPING: {
                return DUMP;
            }
        }
        return super.getResource();
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, int xAxis, int yAxis) {
        ITextComponent component = this.gasModeSupplier.get().getTextComponent();
        int xPos = this.x - this.guiObj.getLeft();
        int yPos = this.y - this.guiObj.getTop();
        if (this.left) {
            this.renderScaledText(component, xPos - 3 - (int)((float)this.getStringWidth(component) * this.getNeededScale(component, 66)), yPos + 1, 0x404040, 66);
        } else {
            this.renderScaledText(component, xPos + this.width + 5, yPos + 1, 0x404040, 66);
        }
        super.renderForeground(mouseX, mouseY, xAxis, yAxis);
    }
}

