/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiArrowSelection;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.item.SeismicReaderContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class GuiSeismicReader
extends GuiMekanism<SeismicReaderContainer> {
    private List<BlockState> blockList = new ArrayList<BlockState>();
    private Object2IntMap<Block> frequencies = new Object2IntOpenHashMap();
    private MekanismButton upButton;
    private MekanismButton downButton;
    private GuiScrollBar scrollBar;

    public GuiSeismicReader(SeismicReaderContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 147;
        this.field_147000_g = 182;
        BlockPos pos = inv.field_70458_d.func_180425_c();
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()), (BlockPos)pos)) {
            this.blockList.add(inv.field_70458_d.field_70170_p.func_180495_p(p));
        }
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 7, 11, 63, 49));
        this.addButton(new GuiInnerScreen(this, 74, 11, 51, 159));
        this.scrollBar = new GuiScrollBar((IGuiWrapper)this, 126, 25, 131, () -> this.blockList.size(), () -> 1);
        this.addButton(this.scrollBar);
        this.addButton(new GuiArrowSelection(this, 76, 81, () -> {
            int currentLayer = this.scrollBar.getCurrentSelection();
            if (currentLayer >= 0) {
                return this.blockList.get(currentLayer).func_177230_c().func_200291_n();
            }
            return null;
        }));
        this.upButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 126, this.getGuiTop() + 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "up.png"), () -> this.scrollBar.adjustScroll(1.0));
        this.addButton(this.upButton);
        this.downButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 126, this.getGuiTop() + 156, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "down.png"), () -> this.scrollBar.adjustScroll(-1.0));
        this.addButton(this.downButton);
        this.updateEnabledButtons();
    }

    public void tick() {
        super.tick();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        int currentLayer = this.scrollBar.getCurrentSelection();
        this.upButton.active = currentLayer + 1 < this.blockList.size();
        this.downButton.active = currentLayer > 0;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int currentLayer = this.scrollBar.getCurrentSelection();
        this.renderScaledText((ITextComponent)MekanismLang.GENERIC.translate(currentLayer), 111, 87, 52480, 13);
        for (int i = 0; i < 9; ++i) {
            int layer = currentLayer + (i - 4);
            if (0 > layer || layer >= this.blockList.size()) continue;
            BlockState state = this.blockList.get(layer);
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
            int renderX = 92;
            int renderY = 147 - 16 * i;
            if (i == 4) {
                this.renderItem(stack, renderX, renderY);
                continue;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)renderX, (float)renderY, (float)0.0f);
            if (i < 4) {
                RenderSystem.translatef((float)1.7f, (float)2.5f, (float)0.0f);
            } else {
                RenderSystem.translatef((float)1.5f, (float)0.0f, (float)0.0f);
            }
            RenderSystem.scalef((float)0.8f, (float)0.8f, (float)0.8f);
            this.renderItem(stack, 0, 0);
            RenderSystem.popMatrix();
        }
        int frequency = 0;
        if (currentLayer >= 0) {
            Block block = this.blockList.get(currentLayer).func_177230_c();
            ITextComponent displayName = block.func_200291_n();
            this.renderScaledText(displayName, 10, 16, 52480, 57);
            frequency = this.frequencies.computeIntIfAbsent((Object)block, b -> (int)this.blockList.stream().filter(blockState -> b == blockState.func_177230_c()).count());
        }
        this.renderScaledText((ITextComponent)MekanismLang.ABUNDANCY.translate(frequency), 10, 26, 52480, 57);
        MekanismRenderer.resetColor();
        super.func_146979_b(mouseX, mouseY);
    }

    public void onClose() {
        super.onClose();
        this.blockList.clear();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.mouseScrolled(mouseX, mouseY, delta);
    }
}

