/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class RotaryCachedRecipe
extends CachedRecipe<RotaryRecipe> {
    private final IOutputHandler<@NonNull GasStack> gasOutputHandler;
    private final IOutputHandler<@NonNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private final BooleanSupplier modeSupplier;

    public RotaryCachedRecipe(RotaryRecipe recipe, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull GasStack> gasInputHandler, IOutputHandler<@NonNull GasStack> gasOutputHandler, IOutputHandler<@NonNull FluidStack> fluidOutputHandler, BooleanSupplier modeSupplier) {
        super(recipe);
        this.fluidInputHandler = fluidInputHandler;
        this.gasInputHandler = gasInputHandler;
        this.gasOutputHandler = gasOutputHandler;
        this.fluidOutputHandler = fluidOutputHandler;
        this.modeSupplier = modeSupplier;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                return -1;
            }
            FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getFluidInput());
            if (recipeFluid.isEmpty()) {
                return -1;
            }
            currentMax = this.fluidInputHandler.operationsCanSupport(((RotaryRecipe)this.recipe).getFluidInput(), currentMax);
            if (currentMax <= 0) {
                return -1;
            }
            return this.gasOutputHandler.operationsRoomFor(((RotaryRecipe)this.recipe).getGasOutput(recipeFluid), currentMax);
        }
        if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return -1;
        }
        currentMax = this.gasInputHandler.operationsCanSupport(((RotaryRecipe)this.recipe).getGasInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.fluidOutputHandler.operationsRoomFor(((RotaryRecipe)this.recipe).getFluidOutput(recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                return false;
            }
            FluidStack fluidStack = this.fluidInputHandler.getInput();
            if (fluidStack.isEmpty()) {
                return false;
            }
            return ((RotaryRecipe)this.recipe).test(fluidStack);
        }
        if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
            return false;
        }
        GasStack gasStack = this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return false;
        }
        return ((RotaryRecipe)this.recipe).test(gasStack);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.modeSupplier.getAsBoolean()) {
            if (((RotaryRecipe)this.recipe).hasFluidToGas()) {
                FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getFluidInput());
                if (recipeFluid.isEmpty()) {
                    return;
                }
                this.fluidInputHandler.use(recipeFluid, operations);
                this.gasOutputHandler.handleOutput(((RotaryRecipe)this.recipe).getGasOutput(recipeFluid), operations);
            }
        } else if (((RotaryRecipe)this.recipe).hasGasToFluid()) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getGasInput());
            if (recipeGas.isEmpty()) {
                return;
            }
            this.gasInputHandler.use(recipeGas, operations);
            this.fluidOutputHandler.handleOutput(((RotaryRecipe)this.recipe).getFluidOutput(recipeGas), operations);
        }
    }
}

