/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.ISidedInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.inventory.AutomationType;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismInfusionHandler
extends ISidedInfusionHandler {
    default public boolean canHandleInfusion() {
        return true;
    }

    public List<IInfusionTank> getInfusionTanks(@Nullable Direction var1);

    public void onContentsChanged();

    @Nullable
    default public IInfusionTank getInfusionTank(int tank, @Nullable Direction side) {
        List<IInfusionTank> tanks = this.getInfusionTanks(side);
        return tank >= 0 && tank < tanks.size() ? tanks.get(tank) : null;
    }

    @Override
    default public int getInfusionTankCount(@Nullable Direction side) {
        return this.getInfusionTanks(side).size();
    }

    @Override
    default public InfusionStack getInfusionInTank(int tank, @Nullable Direction side) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        return infusionTank == null ? InfusionStack.EMPTY : (InfusionStack)infusionTank.getStack();
    }

    @Override
    default public void setInfusionInTank(int tank, InfusionStack stack, @Nullable Direction side) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        if (infusionTank != null) {
            infusionTank.setStack(stack);
        }
    }

    @Override
    default public long getInfusionTankCapacity(int tank, @Nullable Direction side) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        return infusionTank == null ? 0L : infusionTank.getCapacity();
    }

    @Override
    default public boolean isInfusionValid(int tank, InfusionStack stack, @Nullable Direction side) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        return infusionTank != null && infusionTank.isValid(stack);
    }

    @Override
    default public InfusionStack insertInfusion(int tank, InfusionStack stack, @Nullable Direction side, Action action) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        return infusionTank == null ? stack : infusionTank.insert(stack, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public InfusionStack extractInfusion(int tank, long amount, @Nullable Direction side, Action action) {
        IInfusionTank infusionTank = this.getInfusionTank(tank, side);
        return infusionTank == null ? InfusionStack.EMPTY : (InfusionStack)infusionTank.extract(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }
}

