/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasHandlerWrapper
implements IChemicalHandlerWrapper<Gas, GasStack> {
    @Nonnull
    private final IGasHandler handler;

    public GasHandlerWrapper(IGasHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getTanks() {
        return this.handler.getGasTankCount();
    }

    @Override
    public GasStack getChemicalInTank(int tank) {
        return this.handler.getGasInTank(tank);
    }

    @Override
    public void setChemicalInTank(int tank, GasStack stack) {
        this.handler.setGasInTank(tank, stack);
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getGasTankCapacity(tank);
    }

    @Override
    public boolean isChemicalValid(int tank, GasStack stack) {
        return this.handler.isGasValid(tank, stack);
    }

    @Override
    public GasStack insertChemical(int tank, GasStack stack, Action action) {
        return this.handler.insertGas(tank, stack, action);
    }

    @Override
    public GasStack extractChemical(int tank, long amount, Action action) {
        return this.handler.extractGas(tank, amount, action);
    }

    @Override
    public GasStack insertChemical(GasStack stack, Action action) {
        return this.handler.insertGas(stack, action);
    }

    @Override
    public GasStack extractChemical(long amount, Action action) {
        return this.handler.extractGas(amount, action);
    }

    @Override
    public GasStack extractChemical(GasStack stack, Action action) {
        return this.handler.extractGas(stack, action);
    }
}

