/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.network;

import com.maciej916.maenchants.MaEnchants;
import com.maciej916.maenchants.capabilities.IEnchants;
import com.maciej916.maenchants.utils.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketMultiJumpSync {
    private final int multiJump;

    public PacketMultiJumpSync(int multiJump) {
        this.multiJump = multiJump;
    }

    public PacketMultiJumpSync(PacketBuffer buf) {
        this.multiJump = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.multiJump);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = MaEnchants.proxy.getClientPlayer();
            IEnchants enchantsCap = PlayerUtil.getEnchantsCapability(player);
            enchantsCap.setMultiJump(this.multiJump);
        });
        ctx.get().setPacketHandled(true);
    }
}

