/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandTpa {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tpa").requires(source -> source.func_197034_c(0));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandTpa.tpa((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandTpa.tpaArgs((CommandContext<CommandSource>)context)));
        dispatcher.register(builder);
    }

    private static int tpa(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("maessentials.provide.player", new Object[0]));
        return 1;
    }

    private static int tpaArgs(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        CommandTpa.doTpa(player, targetPlayer);
        return 1;
    }

    private static void doTpa(ServerPlayerEntity player, ServerPlayerEntity target) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (player == target) {
            player.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.self", new Object[0]));
            return;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("tpa", ConfigValues.tpa_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown.teleport", cooldown));
            return;
        }
        eslPlayer.getUsage().setCommandUsage("tpa");
        eslPlayer.saveData();
        if (Methods.requestTeleport(player, player, target, ConfigValues.tpa_timeout.intValue())) {
            player.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.request", target.func_145748_c_()));
            target.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.request.target", player.func_145748_c_()));
            ClickEvent clickEventAccept = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tpaccept " + player.func_145748_c_().getString());
            HoverEvent eventHoverAccept = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)Methods.formatText("tpa.maessentials.request.target.accept.hover", "/tpaccept " + player.func_145748_c_().getString()));
            StringTextComponent textAccept = new StringTextComponent("/tpaccept");
            textAccept.func_150256_b().func_150241_a(clickEventAccept);
            textAccept.func_150256_b().func_150209_a(eventHoverAccept);
            target.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.request.target.accept", textAccept));
            ClickEvent clickEventDeny = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tpdeny " + player.func_145748_c_().getString());
            HoverEvent eventHoverDeny = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)Methods.formatText("tpa.maessentials.request.target.deny.hover", "/tpdeny " + player.func_145748_c_().getString()));
            StringTextComponent textDeny = new StringTextComponent("/tpdeny");
            textDeny.func_150256_b().func_150241_a(clickEventDeny);
            textDeny.func_150256_b().func_150209_a(eventHoverDeny);
            target.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.request.target.deny", textDeny));
        }
    }
}

