/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class EntityPathPacket {
    ArrayList<Integer> entities;
    ArrayList<Path> paths;

    public EntityPathPacket() {
    }

    public EntityPathPacket(ArrayList<Integer> entities, ArrayList<Path> paths) {
        this.entities = entities;
        this.paths = paths;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.entities = new ArrayList();
        this.paths = new ArrayList();
        int n = buf.readInt();
        for (i = 0; i < n; ++i) {
            this.entities.add(buf.readInt());
        }
        n = buf.readInt();
        for (i = 0; i < n; ++i) {
            int points = buf.readInt();
            if (points <= 0) continue;
            PathPoint[] p = new PathPoint[points];
            for (int j = 0; j < points; ++j) {
                p[j] = new PathPoint(buf.readInt(), buf.readInt(), buf.readInt());
            }
            this.paths.add(new Path(Arrays.asList(p), p[p.length - 1].func_224759_a(), false));
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.entities.size());
        for (i = 0; i < this.entities.size(); ++i) {
            buf.writeInt(this.entities.get(i).intValue());
        }
        buf.writeInt(this.paths.size());
        for (i = 0; i < this.paths.size(); ++i) {
            int points = this.paths.get(i).func_75874_d();
            buf.writeInt(points);
            for (int j = 0; j < points; ++j) {
                PathPoint p = this.paths.get(i).func_75877_a(j);
                buf.writeInt(p.field_75839_a);
                buf.writeInt(p.field_75837_b);
                buf.writeInt(p.field_75838_c);
            }
        }
    }

    public static void encode(EntityPathPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static EntityPathPacket decode(PacketBuffer buf) {
        EntityPathPacket msg = new EntityPathPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(EntityPathPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.pathHandler(message);
        context.get().setPacketHandled(true);
    }
}

