/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.guide;

import java.util.ArrayList;
import net.minecraft.util.text.TranslationTextComponent;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.item.guide.Page;
import stepsword.mahoutsukai.util.UnorderedList;

public class SpellPage
extends Page {
    String spellNameLang;
    UnorderedList recipe;
    String spellDescLang;
    ArrayList<Integer> values;
    String clothLang;

    public SpellPage(String spellName, UnorderedList recipe, String langKey) {
        this.spellNameLang = spellName;
        this.recipe = recipe;
        this.spellDescLang = langKey;
        this.values = new ArrayList();
        this.clothLang = MahoujinRecipeRegistrar.needsCloth.containsKey(recipe) ? (MahoujinRecipeRegistrar.needsCloth.get(recipe).booleanValue() ? "mahoutsukai.book.cloth_required.name" : "mahoutsukai.book.cloth_optional.name") : "mahoutsukai.book.no_cloth.name";
    }

    public SpellPage setValues(Integer ... values) {
        for (Integer x : values) {
            this.values.add(x);
        }
        return this;
    }

    @Override
    public String getTitle() {
        return new TranslationTextComponent(this.spellNameLang, new Object[0]).func_150261_e();
    }

    public String getCloth() {
        return new TranslationTextComponent(this.clothLang, new Object[0]).func_150261_e();
    }

    public String getDescription() {
        return this.processString(new TranslationTextComponent(this.spellDescLang, new Object[0]).func_150261_e());
    }

    public String processString(String s) {
        int k = 0;
        for (Integer v : this.values) {
            s = s.replace("%val" + k++, v + "");
        }
        s = s.replace("%n", "\n");
        return s;
    }

    public UnorderedList getRecipe() {
        return this.recipe;
    }
}

