/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFamiliarReceptacle
extends ItemGeneric {
    public ItemFamiliarReceptacle() {
        super("familiar_receptacle", ItemFamiliarReceptacle.getBuilder(true).func_200917_a(1));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_150255_a(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.containSoul(stack) || super.func_77636_d(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            if (!this.containSoul(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
                String id = NBTStackHelper.getString(stack, "capturable_type");
                if (!id.isEmpty()) {
                    EntityType entityType = EntityType.func_220327_a((String)id).orElse(null);
                    list.add(LangKey.MESSAGE_IMPREGNATE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, (entityType == null ? LangKey.MESSAGE_UNKNOWN.getTranslation(new Object[0]) : entityType.func_212546_e()).func_150255_a(StyleType.TOOLTIP_ITEM)));
                }
            } else {
                assert (stack.func_77978_p() != null);
                CompoundNBT tagPet = (CompoundNBT)stack.func_77978_p().func_74781_a("dead_pet");
                if (tagPet.func_150297_b("id", 8)) {
                    String id = tagPet.func_74779_i("id");
                    EntityType entityType = EntityType.func_220327_a((String)id).orElse(null);
                    this.addItemDesc(list, "2", (entityType == null ? LangKey.MESSAGE_UNKNOWN.getTranslation(new Object[0]) : entityType.func_212546_e()).func_150255_a(StyleType.TOOLTIP_ITEM));
                    this.addItemUse(list, this.getDurabilityForDisplay(stack) == 0.0 ? "2" : "1", new Object[0]);
                }
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Integer level = (Integer)SharedConfigTombstone.general.familiarReceptacleRequiredLevel.get();
            if (player == null || !Helper.isContributor((PlayerEntity)player) && ((Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> cap.getTotalPerkPoints() < level).orElse((Object)false)).booleanValue()) {
                this.addWarn(list, LangKey.MESSAGE_KNOWLEDGE_REQUIRED, level);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromMinute(1)) && this.containSoul(stack)) {
            float maxHealth;
            CompoundNBT tag = stack.func_77978_p();
            assert (tag != null);
            CompoundNBT tagPet = (CompoundNBT)tag.func_74781_a("dead_pet");
            float health = tagPet.func_150297_b("Health", 5) ? Math.max(0.0f, tagPet.func_74760_g("Health")) : 0.0f;
            float f = maxHealth = tagPet.func_150297_b("max_life", 5) ? Math.max(1.0f, tagPet.func_74760_g("max_life")) : 1.0f;
            if (health < maxHealth) {
                float gain = maxHealth * 0.1f;
                PlayerEntity player = (PlayerEntity)entity;
                tagPet.func_74776_a("Health", Math.min(health + (player.func_110143_aJ() > gain ? gain : player.func_110143_aJ()), maxHealth));
                if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                    player.func_70097_a(ModDamages.BEYOND_THE_GRAVE, gain);
                }
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.containSoul(stack) && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("dead_pet", 10)) {
            CompoundNBT tagPet = (CompoundNBT)tag.func_74781_a("dead_pet");
            float health = tagPet.func_150297_b("Health", 5) ? Math.max(0.0f, tagPet.func_74760_g("Health")) : 0.0f;
            float maxHealth = tagPet.func_150297_b("max_life", 5) ? Math.max(1.0f, tagPet.func_74760_g("max_life")) : 1.0f;
            return 1.0f - health / maxHealth;
        }
        return 1.0;
    }

    public boolean containSoul(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("dead_pet", 10);
    }

    public boolean revive(PlayerEntity player, BlockPos gravePos, ItemStack stack) {
        if (this.containSoul(stack)) {
            LivingEntity entity;
            String id;
            EntityType entityType;
            assert (stack.func_77978_p() != null);
            CompoundNBT tagPet = (CompoundNBT)stack.func_77978_p().func_74781_a("dead_pet");
            if (tagPet.func_150297_b("id", 8) && (entityType = (EntityType)EntityType.func_220327_a((String)(id = tagPet.func_74779_i("id"))).orElse(null)) != null && (entity = (LivingEntity)entityType.func_200721_a(player.field_70170_p)) != null) {
                tagPet.func_82580_o("max_life");
                entity.func_70020_e(tagPet);
                entity.func_70606_j(entity.func_110138_aP());
                entity.field_70128_L = false;
                entity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
                entity.field_71093_bK = player.field_71093_bK;
                if (entity instanceof TameableEntity) {
                    TameableEntity pet = (TameableEntity)entity;
                    pet.func_193101_c(player);
                } else if (entity instanceof AbstractHorseEntity) {
                    AbstractHorseEntity horse = (AbstractHorseEntity)entity;
                    horse.func_110263_g(player);
                }
                EffectHelper.clearBadEffects(entity);
                player.field_70170_p.func_217376_c((Entity)entity);
                return true;
            }
        }
        return false;
    }

    public ItemStack setCapturableType(ItemStack stack, String type) {
        NBTStackHelper.setString(stack, "capturable_type", type);
        return stack;
    }

    private boolean canCaptureSoul(ItemStack stack, LivingEntity entity) {
        String type = stack.func_77978_p() != null ? NBTStackHelper.getString(stack, "capturable_type") : "";
        return type.isEmpty() || type.equals(entity.func_200600_R().getRegistryName().toString());
    }

    public boolean captureSoul(@Nullable LivingEntity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        boolean isTameable = entity instanceof TameableEntity;
        boolean isHorse = !isTameable && entity instanceof AbstractHorseEntity;
        UUID ownerId = null;
        if (isTameable) {
            ownerId = ((TameableEntity)entity).func_184753_b();
        }
        if (isHorse) {
            ownerId = ((AbstractHorseEntity)entity).func_184780_dh();
        }
        if (ownerId != null && entity.func_184102_h() != null) {
            ServerPlayerEntity owner = entity.func_184102_h().func_184103_al().func_177451_a(ownerId);
            if (owner == null && entity.func_184102_h().func_152358_ax().func_152652_a(ownerId) == null) {
                return false;
            }
            String id = entity.func_70022_Q();
            if (id != null && !Helper.containRL((List)ConfigTombstone.decorative_grave.blackListCapturableSouls.get(), new ResourceLocation(id))) {
                boolean hasReceptacle;
                ItemStack receptacle = owner == null ? ItemStack.field_190927_a : (ItemStack)owner.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(inventPlayer -> IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == this && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)).findFirst().orElse(ItemStack.field_190927_a)).orElse((Object)ItemStack.field_190927_a);
                boolean bl = hasReceptacle = !receptacle.func_190926_b();
                if (hasReceptacle && EventFactory.onCaptureSoul((PlayerEntity)owner, entity)) {
                    hasReceptacle = false;
                }
                if (!hasReceptacle && !((Boolean)ConfigTombstone.recovery.recoveryFamiliarEnable.get()).booleanValue()) {
                    return false;
                }
                if (hasReceptacle) {
                    if (entity.func_184218_aH()) {
                        entity.func_184210_p();
                    }
                    if (entity.func_184207_aI()) {
                        entity.func_184226_ay();
                    }
                }
                CompoundNBT pet_tag = entity.serializeNBT();
                pet_tag.func_82580_o("Dimension");
                pet_tag.func_82580_o("Motion");
                pet_tag.func_82580_o("UUID");
                pet_tag.func_82580_o("UpdateBlocked");
                pet_tag.func_74776_a("Health", 0.0f);
                pet_tag.func_74776_a("max_life", entity.func_110138_aP());
                if (!hasReceptacle) {
                    CommandTBReviveFamiliar.saveFamiliar(entity.func_184102_h(), ownerId, pet_tag, entity.func_110124_au().toString());
                } else {
                    entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inventory -> IntStream.range(0, inventory.getSlots()).forEach(slot -> {
                        ItemStack currentStack = inventory.getStackInSlot(slot);
                        if (!currentStack.func_190926_b()) {
                            inventory.extractItem(slot, currentStack.func_190916_E(), false);
                        }
                    }));
                    if (isHorse && entity instanceof AbstractChestedHorseEntity) {
                        ((AbstractChestedHorseEntity)entity).func_110207_m(false);
                    }
                    receptacle.func_196082_o().func_218657_a("dead_pet", (INBT)pet_tag);
                    assert (owner != null);
                    owner.func_145747_a(LangKey.MESSAGE_CAPTURE_FAMILIAR.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, entity.func_200200_C_()));
                    ModTriggers.CAPTURE_SOUL.trigger(owner);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("dead_pet", 10)) {
            CompoundNBT tag = stack.func_77978_p().func_74737_b();
            CompoundNBT pet_tag = (CompoundNBT)tag.func_74781_a("dead_pet");
            if (pet_tag.func_150297_b("id", 8)) {
                CompoundNBT newTag = new CompoundNBT();
                newTag.func_74778_a("id", pet_tag.func_74779_i("id"));
                newTag.func_74776_a("Health", pet_tag.func_74760_g("Health"));
                newTag.func_74776_a("max_life", pet_tag.func_74760_g("max_life"));
                tag.func_218657_a("dead_pet", (INBT)newTag);
            } else {
                pet_tag.func_82580_o("dead_pet");
            }
            return tag;
        }
        return stack.func_77978_p();
    }
}

