/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigGroup;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public abstract class ConfigValue<T>
implements Comparable<ConfigValue<T>> {
    public ConfigGroup group;
    public T value;
    public Consumer<T> setter;
    public T defaultValue;
    public String id = "";
    private int order = 0;
    private String nameKey = "";
    private Icon icon = GuiIcons.SETTINGS;
    private boolean canEdit = true;

    public ConfigValue<T> init(ConfigGroup g, String i, @Nullable T v, Consumer<T> c, @Nullable T def) {
        this.group = g;
        this.id = i;
        this.value = v == null ? null : this.copy(v);
        this.setter = c;
        this.defaultValue = def;
        this.order = g.getValues().size();
        return this;
    }

    public final boolean setCurrentValue(@Nullable T v) {
        if (!this.isEqual(this.value, v)) {
            this.value = v;
            return true;
        }
        return false;
    }

    public boolean isEqual(@Nullable T v1, @Nullable T v2) {
        return Objects.equals(v1, v2);
    }

    public T copy(T value) {
        return value;
    }

    public Color4I getColor(@Nullable T v) {
        return Color4I.GRAY;
    }

    public void addInfo(List<String> list) {
        list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + this.getStringForGUI(this.defaultValue));
    }

    public abstract void onClicked(MouseButton var1, ConfigCallback var2);

    public String getStringForGUI(@Nullable T v) {
        return String.valueOf(v);
    }

    public String getPath() {
        String p = this.group.getPath();
        return p.isEmpty() ? this.id : p + '.' + this.id;
    }

    public String getNameKey() {
        return this.nameKey.isEmpty() ? this.getPath() : this.nameKey;
    }

    public ConfigValue<T> setNameKey(String key) {
        this.nameKey = key;
        return this;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.getNameKey(), (Object[])new Object[0]);
    }

    public String getTooltip() {
        String k = this.getNameKey() + ".tooltip";
        return I18n.func_188566_a((String)k) ? I18n.func_135052_a((String)k, (Object[])new Object[0]) : "";
    }

    public ConfigValue<T> setOrder(int o) {
        this.order = o;
        return this;
    }

    public ConfigValue<T> setCanEdit(boolean e) {
        this.canEdit = e;
        return this;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public ConfigValue<T> setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon(@Nullable T v) {
        return this.icon;
    }

    @Override
    public int compareTo(ConfigValue<T> o) {
        int i = this.group.getPath().compareToIgnoreCase(o.group.getPath());
        if (i == 0) {
            i = Integer.compare(this.order, o.order);
        }
        return i;
    }
}

