/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigList;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class ConfigList<E, CV extends ConfigValue<E>>
extends ConfigValue<List<E>> {
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final CV type;

    public ConfigList(CV t) {
        this.type = t;
    }

    @Override
    public List<E> copy(List<E> v) {
        ArrayList<E> list = new ArrayList<E>(v.size());
        for (E value : v) {
            list.add(((ConfigValue)this.type).copy(value));
        }
        return list;
    }

    @Override
    public Color4I getColor(List<E> v) {
        return COLOR;
    }

    @Override
    public void addInfo(List<String> l) {
        if (!((List)this.value).isEmpty()) {
            l.add(TextFormatting.AQUA + "List:");
            for (Object value : (List)this.value) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
            if (!((List)this.defaultValue).isEmpty()) {
                l.add("");
            }
        }
        if (!((List)this.defaultValue).isEmpty()) {
            l.add(TextFormatting.AQUA + "Default:");
            for (Object value : (List)this.defaultValue) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, ConfigCallback callback) {
        new GuiEditConfigList(this, callback).openGui();
    }

    @Override
    public String getStringForGUI(List<E> v) {
        return v.isEmpty() ? "[]" : "[...]";
    }
}

